/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.profiling.data;

/**
 * The {@link ProfilingIdGenerator} has to work thread dependent. So the id generated by
 * {@link ProfilingIdGenerator#create()} should only be retrievable by calls to
 * {@link ProfilingIdGenerator#getCurrent()} and removable by calls to
 * {@link ProfilingIdGenerator#remove()} from the same thread. The id for one thread has to be equal
 * for all calls to {@link ProfilingIdGenerator#getCurrent()} between an initial call to
 * {@link ProfilingIdGenerator#create()} and a call to {@link ProfilingIdGenerator#remove()}. Ids
 * should be unique within a reasonable amount of time.
 * 
 */
public interface ProfilingIdGenerator {

    /**
     * Creates and returns a new id for the current thread.
     * 
     * @return the newly created id.
     */
    String create();

    /**
     * Get the current id for the current thread.
     * 
     * @return the current id for the current thread, or null if none has been created or remove was
     *         called.
     */
    String getCurrent();

    /**
     * Discard the id for the current thread.
     */
    void remove();
}
