/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sitemap.spring.PipelineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionPipelineFactory
implements PipelineFactory {
    private Map<String, Class<? extends Pipeline<PipelineComponent>>> types = new HashMap<String, Class<? extends Pipeline<PipelineComponent>>>();

    @Override
    public Pipeline<PipelineComponent> createPipeline(String type) {
        Class<? extends Pipeline<PipelineComponent>> pipelineClass = this.types.get(type);
        if (pipelineClass == null) {
            throw new IllegalArgumentException("Pipeline type '" + type + "' is not supported.");
        }
        try {
            Pipeline<PipelineComponent> pipeline = pipelineClass.newInstance();
            return pipeline;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("A pipeline of type '" + type + "' could not be created.", e);
        }
    }

    public void setTypes(Map<String, String> types) {
        for (Map.Entry<String, String> entry : types.entrySet()) {
            try {
                Class<?> nodeClass = Class.forName(entry.getValue());
                this.types.put(entry.getKey(), nodeClass);
            }
            catch (ClassCastException ccex) {
                throw new IllegalArgumentException("Could not register class " + entry.getValue() + " as type " + entry.getKey(), ccex);
            }
            catch (ClassNotFoundException cnfex) {
                throw new IllegalArgumentException("Could not register class " + entry.getValue() + " as type " + entry.getKey(), cnfex);
            }
        }
    }
}

