/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sitemap.spring.PipelineComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionPipelineComponentFactory
implements PipelineComponentFactory {
    private Map<String, Class<? extends PipelineComponent>> types = new HashMap<String, Class<? extends PipelineComponent>>();

    public void setTypes(Map<String, String> types) {
        for (Map.Entry<String, String> entry : types.entrySet()) {
            try {
                Class<?> nodeClass = Class.forName(entry.getValue());
                this.types.put(entry.getKey(), nodeClass);
            }
            catch (ClassCastException ccex) {
                throw new IllegalArgumentException("Could not register class " + entry.getValue() + " as component type " + entry.getKey(), ccex);
            }
            catch (ClassNotFoundException cnfex) {
                throw new IllegalArgumentException("Could not register class " + entry.getValue() + " as component type " + entry.getKey(), cnfex);
            }
        }
    }

    @Override
    public PipelineComponent createComponent(String type) {
        Class<? extends PipelineComponent> componentClass = this.types.get(type);
        if (componentClass == null) {
            throw new IllegalArgumentException("Pipeline component type '" + type + "' is not supported.");
        }
        try {
            return componentClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("A component of type '" + type + "' could not be created.", e);
        }
    }
}

