/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.sitemap.action.Action;
import org.apache.cocoon.sitemap.spring.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionActionFactory
implements ActionFactory {
    private final Map<String, Class<? extends Action>> types = new HashMap<String, Class<? extends Action>>();

    @Override
    public Action createAction(String type) {
        Class<? extends Action> actionClass = this.types.get(type);
        if (actionClass == null) {
            throw new IllegalArgumentException("Action type '" + type + "' is not supported.");
        }
        try {
            Action action = actionClass.newInstance();
            return action;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An action of type '" + type + "' could not be created.", e);
        }
    }

    public void setTypes(Map<String, String> types) {
        this.types.clear();
        for (Map.Entry<String, String> entry : types.entrySet()) {
            try {
                Class<?> actionClass = Class.forName(entry.getValue());
                this.types.put(entry.getKey(), actionClass);
            }
            catch (ClassCastException ccex) {
                throw new IllegalArgumentException("Could not register class " + entry.getValue() + " as type " + entry.getKey(), ccex);
            }
            catch (ClassNotFoundException cnfex) {
                throw new IllegalArgumentException("Could not register class " + entry.getValue() + " as type " + entry.getKey(), cnfex);
            }
        }
    }
}

