/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.node;

import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.NoMatchingPipelineException;
import org.apache.cocoon.sitemap.node.AbstractSitemapNode;
import org.apache.cocoon.sitemap.node.ErrorNode;
import org.apache.cocoon.sitemap.node.InvocationResult;
import org.apache.cocoon.sitemap.node.Node;
import org.apache.cocoon.sitemap.node.annotations.NodeChild;
import org.apache.cocoon.sitemap.util.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Node(name="pipelines")
public class PipelinesNode
extends AbstractSitemapNode {
    @NodeChild
    private ErrorNode errorNode;

    @Override
    public Class<?> getType() {
        return PipelinesNode.class;
    }

    @Override
    public InvocationResult invoke(Invocation invocation) {
        try {
            if (super.invoke(invocation).isContinued()) {
                return InvocationResult.COMPLETED;
            }
            throw new NoMatchingPipelineException("No pipeline matched the request '" + invocation.getRequestURI() + "'");
        }
        catch (Exception ex) {
            return this.handleException(invocation, ex);
        }
    }

    private InvocationResult handleException(Invocation invocation, Exception ex) {
        if (this.errorNode != null) {
            invocation.setThrowable(ExceptionHandler.getCause(ex));
            if (this.errorNode.invoke(invocation).isCompleted()) {
                return InvocationResult.COMPLETED;
            }
        }
        throw ExceptionHandler.getInvocationException(ex);
    }
}

