/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.node;

import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.node.AbstractSitemapNode;
import org.apache.cocoon.sitemap.node.ErrorNode;
import org.apache.cocoon.sitemap.node.InvocationResult;
import org.apache.cocoon.sitemap.node.Node;
import org.apache.cocoon.sitemap.node.annotations.NodeChild;
import org.apache.cocoon.sitemap.node.annotations.Parameter;
import org.apache.cocoon.sitemap.util.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Node(name="pipeline")
public class PipelineNode
extends AbstractSitemapNode {
    private static final String PIPELINE_CATEGORY = "pipeline:";
    @NodeChild
    private ErrorNode errorNode;
    @Parameter
    private String type = "caching";

    @Override
    public Class<?> getType() {
        return PipelineNode.class;
    }

    @Override
    public InvocationResult invoke(Invocation invocation) {
        this.installPipeline(invocation);
        this.clearActions(invocation);
        try {
            if (!super.invoke(invocation).isContinued()) {
                return InvocationResult.NONE;
            }
            invocation.execute();
            return InvocationResult.COMPLETED;
        }
        catch (Exception ex) {
            return this.handleException(invocation, ex);
        }
    }

    private void clearActions(Invocation invocation) {
        invocation.reset();
    }

    @Override
    public String toString() {
        return "PipelineNode(" + this.type + ")";
    }

    private InvocationResult handleException(Invocation invocation, Exception ex) {
        if (this.errorNode != null) {
            invocation.setThrowable(ExceptionHandler.getCause(ex));
            if (this.errorNode.invoke(invocation).isCompleted()) {
                return InvocationResult.COMPLETED;
            }
        }
        throw ExceptionHandler.getInvocationException(ex);
    }

    protected void installPipeline(Invocation invocation) {
        invocation.installPipeline(PIPELINE_CATEGORY + this.type, this.getParameters());
    }
}

