/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.node;

import java.util.LinkedList;
import java.util.Map;
import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.matcher.ContainsMatcher;
import org.apache.cocoon.sitemap.matcher.EndsWithMatcher;
import org.apache.cocoon.sitemap.matcher.EqualsMatcher;
import org.apache.cocoon.sitemap.matcher.Matcher;
import org.apache.cocoon.sitemap.matcher.RegexpMatcher;
import org.apache.cocoon.sitemap.matcher.StartsWithMatcher;
import org.apache.cocoon.sitemap.matcher.WildcardMatcher;
import org.apache.cocoon.sitemap.node.AbstractSitemapNode;
import org.apache.cocoon.sitemap.node.InvocationResult;
import org.apache.cocoon.sitemap.node.Node;
import org.apache.cocoon.sitemap.node.annotations.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Node(name="match")
public class MatchNode
extends AbstractSitemapNode {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Parameter
    private String name;
    @Parameter
    private String value;
    @Parameter
    private String pattern;
    @Parameter
    private String regexp;
    @Parameter
    private String equals;
    @Parameter
    private String contains;
    @Parameter
    private String wildcard;
    @Parameter
    private String startsWith;
    @Parameter
    private String endsWith;
    private MatcherContext matcherContext;
    private Map<String, String> matches;

    @Override
    public InvocationResult invoke(Invocation invocation) {
        String testValue = invocation.resolveParameter(this.value);
        if (testValue == null && (testValue = invocation.getRequestURI()).startsWith("/")) {
            testValue = testValue.substring(1);
        }
        this.matcherContext = this.lookupMatcherContext();
        if (this.matcherContext == null) {
            throw new MatchingAttributeException("Use on of the matching attributes: wildcard, equals, regexp, starts-with, ends-with, contains");
        }
        this.matches = this.matcherContext.match(testValue);
        if (this.matches == null) {
            return InvocationResult.NONE;
        }
        invocation.pushSitemapParameters(this.name, this.matches);
        InvocationResult invocationResult = super.invoke(invocation);
        invocation.popSitemapParameters();
        if (invocationResult.isContinued()) {
            if (invocation.hasCompletePipeline()) {
                return InvocationResult.COMPLETED;
            }
            return InvocationResult.CONTINUE;
        }
        return InvocationResult.NONE;
    }

    protected boolean isMatching() {
        return this.matches != null;
    }

    protected MatcherContext lookupMatcherContext() {
        LinkedList<MatcherContext> matcherContextList = new LinkedList<MatcherContext>();
        if (this.pattern != null) {
            matcherContextList.add(new MatcherContext(new WildcardMatcher(), this.pattern));
        }
        if (this.regexp != null) {
            matcherContextList.add(new MatcherContext(new RegexpMatcher(), this.regexp));
        }
        if (this.equals != null) {
            matcherContextList.add(new MatcherContext(new EqualsMatcher(), this.equals));
        }
        if (this.contains != null) {
            matcherContextList.add(new MatcherContext(new ContainsMatcher(), this.contains));
        }
        if (this.wildcard != null) {
            matcherContextList.add(new MatcherContext(new WildcardMatcher(), this.wildcard));
        }
        if (this.startsWith != null) {
            matcherContextList.add(new MatcherContext(new StartsWithMatcher(), this.startsWith));
        }
        if (this.endsWith != null) {
            matcherContextList.add(new MatcherContext(new EndsWithMatcher(), this.endsWith));
        }
        if (matcherContextList.size() > 1) {
            String message = "Only one matching attribute (regexp, equals, contains, wildcard, pattern) can be set: " + matcherContextList;
            this.logger.error((Object)message);
            throw new MatchingAttributeException(message);
        }
        return matcherContextList.isEmpty() ? null : (MatcherContext)matcherContextList.getFirst();
    }

    @Override
    public Class<?> getType() {
        return MatchNode.class;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    private static class MatchingAttributeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MatchingAttributeException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MatcherContext {
        private static final Log LOG = LogFactory.getLog(MatcherContext.class);
        private Matcher matcher;
        private String expression;

        public MatcherContext(Matcher matcher, String expression) {
            this.matcher = matcher;
            this.expression = expression;
        }

        public Map<String, String> match(String testValue) {
            Map<String, String> result = this.matcher.match(this.expression, testValue);
            if (LOG.isDebugEnabled()) {
                String message = "Matching: expression=" + this.expression + ", testValue=" + testValue + ", result=" + result;
                LOG.debug((Object)message);
            }
            return result;
        }

        public String toString() {
            return "matcher=" + this.matcher + ", expression=" + this.expression;
        }
    }
}

