/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.node;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.node.InvocationResult;
import org.apache.cocoon.sitemap.node.ParameterNode;
import org.apache.cocoon.sitemap.node.SitemapNode;
import org.apache.cocoon.sitemap.node.annotations.NodeChild;
import org.apache.cocoon.sitemap.node.annotations.Parameter;
import org.apache.cocoon.sitemap.util.SpringProxyHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSitemapNode
implements SitemapNode {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<SitemapNode> children = new LinkedList<SitemapNode>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private SitemapNode parent;

    @Override
    public void addChild(SitemapNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Node of class " + this.getClass().getName() + " received null child.");
        }
        if (child.getType().equals(ParameterNode.class)) {
            ParameterNode parameterNode = (ParameterNode)SpringProxyHelper.unpackProxy(child);
            this.processParameter(parameterNode.getName(), parameterNode.getValue());
        } else {
            Field childField = this.getChildField(SpringProxyHelper.unpackProxy(child));
            if (childField != null) {
                childField.setAccessible(true);
                try {
                    childField.set(this, SpringProxyHelper.unpackProxy(child));
                }
                catch (IllegalArgumentException e) {
                    this.logger.error((Object)("Failed to set child field for child class '" + child.getClass().getName()), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.logger.error((Object)("Failed to set child field for child class '" + child.getClass().getName()), (Throwable)e);
                }
            } else {
                this.children.add(child);
            }
        }
        child.setParent(this);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public SitemapNode getParent() {
        return this.parent;
    }

    @Override
    public InvocationResult invoke(Invocation invocation) {
        InvocationResult result = InvocationResult.NONE;
        for (SitemapNode child : this.children) {
            InvocationResult currentResult;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(child + ".invoke(" + invocation.getRequestURI() + ")"));
            }
            if ((currentResult = child.invoke(invocation)).compareTo(result) > 0) {
                result = currentResult;
            }
            if (!result.isCompleted() && result != InvocationResult.BREAK) continue;
            break;
        }
        return result;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Map<String, Field> parameterFields = this.getParameterFields();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Field parameterField = parameterFields.get(key);
            if (parameterField != null) {
                parameterField.setAccessible(true);
                try {
                    parameterField.set(this, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    String message = "Failed to set parameter field " + key;
                    this.logger.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
                catch (IllegalAccessException e) {
                    String message = "Failed to set parameter field " + key;
                    this.logger.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
            this.processParameter(key, value);
        }
    }

    @Override
    public void setParent(SitemapNode parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected void processParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    private Field getChildField(SitemapNode child) {
        for (Class<?> currentClass = this.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = currentClass.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(NodeChild.class) || !declaredField.getType().isAssignableFrom(child.getClass())) continue;
                return declaredField;
            }
        }
        return null;
    }

    private Map<String, Field> getParameterFields() {
        HashMap<String, Field> parameterFields = new HashMap<String, Field>();
        for (Class<?> currentClass = this.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = currentClass.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(Parameter.class)) continue;
                String fieldName = this.convertCamelCase(declaredField.getName());
                parameterFields.put(fieldName, declaredField);
            }
        }
        return parameterFields;
    }

    private String convertCamelCase(String name) {
        Pattern camelCasePattern = Pattern.compile("(.)([A-Z])");
        Matcher matcher = camelCasePattern.matcher(name);
        int lastMatch = 0;
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            result.append(name.substring(lastMatch, matcher.start()));
            result.append(matcher.group(1));
            result.append("-");
            result.append(matcher.group(2).toLowerCase());
            lastMatch = matcher.end();
        }
        result.append(name.substring(lastMatch, name.length()));
        return result.toString();
    }
}

