/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.matcher;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.cocoon.sitemap.matcher.Matcher;
import org.apache.cocoon.sitemap.util.WildcardMatcherHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardMatcher
implements Matcher {
    @Override
    public Map<String, String> match(String expression, String testValue) {
        if (testValue == null) {
            return null;
        }
        WildcardExpressionRewriter rewriter = new WildcardExpressionRewriter(expression);
        Map<String, String> matchingResult = WildcardMatcherHelper.match(rewriter.rewrittenExpression, testValue);
        Map<String, String> parameterGroups = rewriter.getParameters();
        if (matchingResult == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : matchingResult.keySet()) {
            String value = matchingResult.get(key);
            result.put(key, value);
            String param = parameterGroups.get(key);
            if (param == null) continue;
            result.put(param, value);
        }
        return result;
    }

    public static class UnsupportedNamedWildcardExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnsupportedNamedWildcardExpressionException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class WildcardExpressionRewriter {
        private static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\{[\\w\\.\\-]+})");
        private static final Pattern PARAMETER_WILDCARD_PATTERN = Pattern.compile("([\\*]{1,2}|\\{([\\w\\.\\-]+)})");
        private String originalExpression;
        private java.util.regex.Matcher parameterAndWildcardMatcher;
        private Map<String, String> parameters;
        private java.util.regex.Matcher parameterMatcher;
        private String rewrittenExpression;

        public WildcardExpressionRewriter(String originalExpression) {
            this.originalExpression = originalExpression;
            this.checkExpression();
            this.parameterAndWildcardMatcher = PARAMETER_WILDCARD_PATTERN.matcher(originalExpression);
            this.parameterMatcher = PARAMETER_PATTERN.matcher(originalExpression);
            this.parameters = this.findParameters();
            this.rewrittenExpression = this.rewriteExpression();
        }

        public String getOriginalExpression() {
            return this.originalExpression;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public int getParameterPosition(String parameterName) {
            return 1;
        }

        public String getRewrittenExpression() {
            return this.rewrittenExpression;
        }

        private void checkExpression() {
            if (this.originalExpression.contains("}{")) {
                throw new UnsupportedNamedWildcardExpressionException("}{ is not allowed (" + this.originalExpression + "). There must be a seperating character between two named wildcards.");
            }
        }

        private Map<String, String> findParameters() {
            HashMap<String, String> parameterNames = new HashMap<String, String>();
            int count = 1;
            while (this.parameterAndWildcardMatcher.find()) {
                String group2 = this.parameterAndWildcardMatcher.group(2);
                if (group2 != null) {
                    parameterNames.put(Integer.toString(count), group2);
                }
                ++count;
            }
            return parameterNames;
        }

        private String rewriteExpression() {
            return this.parameterMatcher.replaceAll("*");
        }
    }
}

