/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.component;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.TimestampCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.sitemap.component.AbstractReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileReaderComponent
extends AbstractReader
implements CachingPipelineComponent {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public FileReaderComponent() {
    }

    public FileReaderComponent(URL source) {
        super(source);
    }

    public CacheKey constructCacheKey() {
        try {
            URLConnection connection = this.source.openConnection();
            TimestampCacheKey timestampCacheKey = new TimestampCacheKey(this.source, connection.getLastModified());
            URLConnectionUtils.closeQuietly((URLConnection)connection);
            return timestampCacheKey;
        }
        catch (IOException e) {
            this.logger.error((Object)("Can't construct cache key. Error while connecting to " + this.source), (Throwable)e);
            return null;
        }
    }

    public void execute() {
        InputStream inputStream = null;
        if (this.source == null) {
            throw new IllegalArgumentException("FileReaderComponent has no source configured to read from.");
        }
        URLConnection connection = null;
        try {
            int bytesRead;
            connection = this.source.openConnection();
            inputStream = connection.getInputStream();
            byte[] data = new byte[1024];
            while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                this.outputStream.write(data, 0, bytesRead);
            }
        }
        catch (IOException e) {
            String message = "FileReader cannot read from '" + this.source + "'";
            this.logger.error((Object)message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
        finally {
            URLConnectionUtils.closeQuietly((URLConnection)connection);
        }
    }

    public String getContentType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        URLConnection connection = null;
        try {
            connection = this.source.openConnection();
            String string = connection.getContentType();
            return string;
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        finally {
            URLConnectionUtils.closeQuietly((URLConnection)connection);
        }
    }

    public String toString() {
        return "ReaderComponent(" + this.source + ")";
    }
}

