/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.sax.AbstractSAXProducer;
import org.apache.cocoon.sitemap.util.ParameterHelper;
import org.apache.cocoon.xml.sax.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionGenerator
extends AbstractSAXProducer
implements Starter {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    public static final String EXCEPTION_NS = "";
    private Map<String, Object> parameters;

    private static void simpleElement(String name, Attributes attr, String value, ContentHandler handler) throws SAXException {
        handler.startElement(EXCEPTION_NS, name, name, attr);
        if (value != null && value.length() > 0) {
            handler.characters(value.toCharArray(), 0, value.length());
        }
        handler.endElement(EXCEPTION_NS, name, name);
    }

    public void execute() {
        Throwable throwable = ParameterHelper.getThrowable(this.parameters);
        try {
            this.getSAXConsumer().startDocument();
            this.toSAX(throwable, (ContentHandler)this.getSAXConsumer());
            this.getSAXConsumer().endDocument();
        }
        catch (SAXException e) {
            throw new ProcessingException("Failed to generate exception document.", (Throwable)e);
        }
    }

    private void toSAX(Throwable throwable, ContentHandler handler) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("class", throwable.getClass().getName());
        attr.addCDATAAttribute("timestamp", this.dateFormat.format(new Date()));
        handler.startElement(EXCEPTION_NS, "exception-report", "exception-report", (Attributes)attr);
        attr.clear();
        ExceptionGenerator.simpleElement("message", (Attributes)attr, throwable.getMessage(), handler);
        attr.clear();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        ExceptionGenerator.simpleElement("stacktrace", (Attributes)attr, sw.getBuffer().toString(), handler);
        handler.endElement(EXCEPTION_NS, "exception-report", "exception-report");
    }

    public void setup(Map<String, Object> parameters) {
        super.setup(parameters);
        this.parameters = parameters;
    }
}

