/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitemapParametersStack {
    private static final Pattern ABSOLUTE_PARAMETER_PATTERN = Pattern.compile("([a-zA-z0-9]+)/(.+)");
    private static final String RELATIVE_LOCATION_PREFIX = "../";
    private static final Pattern RELATIVE_PARAMETER_PATTERN = Pattern.compile("((" + Pattern.quote("../") + ")*)(.+)");
    private Stack<Entry> entries = new Stack();

    public String getParameter(String parameterName) {
        Matcher absoluteParameterMatcher = ABSOLUTE_PARAMETER_PATTERN.matcher(parameterName);
        if (absoluteParameterMatcher.matches()) {
            return this.resolveAbsoluteParameter(parameterName, absoluteParameterMatcher);
        }
        Matcher relativeParameterMatcher = RELATIVE_PARAMETER_PATTERN.matcher(parameterName);
        if (relativeParameterMatcher.matches()) {
            return this.resolveRelativeParameter(relativeParameterMatcher);
        }
        throw new IllegalArgumentException("Sitemap parameter '" + parameterName + "' is invalid. Valid formats are: '" + ABSOLUTE_PARAMETER_PATTERN.pattern() + "' or '" + RELATIVE_PARAMETER_PATTERN.pattern() + "'");
    }

    public void popParameters() {
        this.entries.pop();
    }

    public void pushParameters(String name, Map<String, ? extends Object> parameters) {
        this.entries.push(new Entry(name, parameters));
    }

    private String resolveAbsoluteParameter(String parameterName, Matcher absoluteParameterMatcher) {
        String entryName = absoluteParameterMatcher.group(1);
        String name = absoluteParameterMatcher.group(2);
        for (Entry entry : this.entries) {
            if (!entryName.equals(entry.getName())) continue;
            Object result = entry.getParameter(name);
            if (result == null) {
                return null;
            }
            return result.toString();
        }
        throw new IllegalArgumentException("Sitemap parameter '" + parameterName + "' could not be resolved. There was no entry for the name '" + entryName + "'");
    }

    private String resolveRelativeParameter(Matcher relativeParameterMatcher) {
        String levelPrefix = relativeParameterMatcher.group(2);
        String name = relativeParameterMatcher.group(3);
        int level = levelPrefix == null ? 0 : levelPrefix.length() / RELATIVE_LOCATION_PREFIX.length();
        int index = this.entries.size() - level - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Sitemap parameter '" + relativeParameterMatcher.group() + "' could not be resolved. There are only " + this.entries.size() + " entries available, but " + level + " entries were requested.");
        }
        Entry entry = (Entry)this.entries.get(index);
        Object result = entry.getParameter(name);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private String name;
        private Map<String, ? extends Object> parameters;

        public Entry(String name, Map<String, ? extends Object> parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public Object getParameter(String parameterName) {
            return this.parameters.get(parameterName);
        }
    }
}

