/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.cocoon.sitemap.node.SitemapNode;
import org.apache.cocoon.sitemap.node.SitemapNodeFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitemapBuilder {
    private SitemapNodeFactory sitemapNodeFactory;

    public SitemapNode build(URL sitemap) {
        if (sitemap == null) {
            throw new NullPointerException("A valid sitemap URL has to be passed.");
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        SitemapHandler sitemapHandler = new SitemapHandler();
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputStream inputStream = sitemap.openStream();
            saxParser.parse(inputStream, (DefaultHandler)sitemapHandler);
            inputStream.close();
        }
        catch (Exception e) {
            throw new SitemapBuilderException("Can't build sitemap.", e);
        }
        return sitemapHandler.getSitemap();
    }

    public void setSitemapNodeFactory(SitemapNodeFactory sitemapNodeFactory) {
        this.sitemapNodeFactory = sitemapNodeFactory;
    }

    protected SitemapNode createSitemapNode(String localName, Map<String, String> parameters) {
        return this.sitemapNodeFactory.createNode(localName, parameters);
    }

    private class SitemapHandler
    extends DefaultHandler {
        private SitemapNode currentNode;
        private SitemapNode sitemap;

        private SitemapHandler() {
        }

        public void endElement(String uri, String localName, String name) {
            if (this.currentNode == null) {
                throw new IllegalStateException("Received closing '" + localName + "' but there was no node to close.");
            }
            this.currentNode = this.currentNode.getParent();
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public SitemapNode getSitemap() {
            return this.sitemap;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) {
            if (this.currentNode == null) {
                if (localName.equals("sitemap")) {
                    this.currentNode = this.sitemap = SitemapBuilder.this.createSitemapNode(localName, null);
                    return;
                }
                throw new IllegalStateException("Expected 'sitemap' as first element, but received '" + localName + "'");
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                parameters.put(attributes.getQName(i), attributes.getValue(i));
            }
            SitemapNode node = SitemapBuilder.this.createSitemapNode(localName, parameters);
            this.currentNode.addChild(node);
            this.currentNode = node;
        }
    }

    private static class SitemapBuilderException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SitemapBuilderException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

