/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sitemap.ComponentProvider;
import org.apache.cocoon.sitemap.Invocation;
import org.apache.cocoon.sitemap.action.Action;
import org.apache.cocoon.sitemap.expression.LanguageInterpreter;
import org.apache.cocoon.sitemap.objectmodel.ObjectModel;
import org.apache.cocoon.sitemap.util.ExceptionHandler;
import org.apache.cocoon.sitemap.util.ParameterHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationImpl
implements Invocation {
    private final Log errorLogger = LogFactory.getLog((String)(this.getClass().getName() + "/handle-errors"));
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{([a-zA-Z\\-]+):([^\\{]*)\\}");
    private List<Action> actions = new LinkedList<Action>();
    private ComponentProvider componentProvider;
    private OutputStream outputStream;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Pipeline<PipelineComponent> pipeline;
    private String requestURI;
    private URL baseURL;
    private ObjectModel objectModel;
    private boolean hasFinisher;

    public InvocationImpl() {
    }

    public InvocationImpl(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InvocationImpl(OutputStream outputStream, String requestURI) {
        this.outputStream = outputStream;
        this.requestURI = requestURI;
    }

    public InvocationImpl(OutputStream outputStream, String requestURI, Map<String, Object> parameters) {
        this.outputStream = outputStream;
        this.requestURI = requestURI;
        this.parameters = parameters;
    }

    @Override
    public void reset() {
        this.actions.clear();
        this.hasFinisher = false;
    }

    @Override
    public void execute() throws Exception {
        if (this.pipeline == null) {
            throw new IllegalStateException("InvocationImpl has been executed without having a pipeline.");
        }
        for (Action action : this.actions) {
            action.setup(this.parameters);
        }
        this.pipeline.setup(this.outputStream, this.parameters);
        for (Action action : this.actions) {
            action.execute();
        }
        this.pipeline.execute();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public Throwable getThrowable() {
        return ParameterHelper.getThrowable(this.parameters);
    }

    @Override
    public boolean hasCompletePipeline() {
        return this.hasFinisher;
    }

    @Override
    public void installAction(String type) {
        if (this.pipeline == null) {
            throw new IllegalStateException("Action cannot be installed without having a pipeline.");
        }
        Action action = this.componentProvider.createAction(type);
        this.actions.add(action);
    }

    @Override
    public void installComponent(String type, Map<String, ? extends Object> componentParameters) {
        if (this.pipeline == null) {
            throw new IllegalStateException("Pipeline component cannot be installed without having a pipeline.");
        }
        PipelineComponent component = this.componentProvider.createComponent(type);
        Map<String, ? extends Object> resolvedParameters = this.resolveParameters(componentParameters);
        component.setConfiguration(resolvedParameters);
        this.pipeline.addComponent(component);
        if (component instanceof Finisher) {
            this.hasFinisher = true;
        }
    }

    @Override
    public void installPipeline(String type, Map<String, ? extends Object> componentParameters) {
        this.pipeline = this.componentProvider.createPipeline(type);
        Map<String, ? extends Object> resolvedParameters = this.resolveParameters(componentParameters);
        this.pipeline.setConfiguration(resolvedParameters);
    }

    @Override
    public boolean isErrorInvocation() {
        return this.getThrowable() != null;
    }

    @Override
    public void popSitemapParameters() {
        this.objectModel.getSitemapParameters().popParameters();
    }

    @Override
    public void pushSitemapParameters(String nodeName, Map<String, ? extends Object> sitemapParameters) {
        this.objectModel.getSitemapParameters().pushParameters(nodeName, sitemapParameters);
    }

    @Override
    public URL resolve(String resource) {
        try {
            return new URL(this.baseURL, resource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setComponentProvider(ComponentProvider componentProvider) {
        this.componentProvider = componentProvider;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        Throwable cause = ExceptionHandler.getCause(throwable);
        this.objectModel.getCocoonObject().put("exception", cause);
        ParameterHelper.setThrowable(this.parameters, cause);
        String message = "Error while executing the sitemap. [request-uri=" + this.getRequestURI() + "]";
        this.errorLogger.error((Object)message, throwable);
    }

    private LanguageInterpreter getLanguageInterpreter(String language) {
        return this.componentProvider.getLanguageInterpreter(language);
    }

    @Override
    public String resolveParameter(String parameter) {
        if (parameter == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(parameter);
        Matcher matcher = PARAMETER_PATTERN.matcher(result);
        while (matcher.find()) {
            String language = matcher.group(1);
            LanguageInterpreter languageInterpreter = this.getLanguageInterpreter(language);
            if (languageInterpreter == null) {
                throw new UnsupportedExpressionLanguageException("Could not resolve parameter '" + parameter + "'. The language '" + language + "' is not supported.");
            }
            String variable = matcher.group(2);
            String replacement = languageInterpreter.resolve(variable, this.objectModel);
            if (replacement == null) {
                throw new VariableNotFoundException("Variable {" + language + ":" + variable + "} not found or is null.");
            }
            result.replace(matcher.start(), matcher.end(), replacement);
            matcher.reset();
        }
        return result.toString();
    }

    private Map<String, ? extends Object> resolveParameters(Map<String, ? extends Object> componentParameters) {
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        for (String key : componentParameters.keySet()) {
            Object parameter = componentParameters.get(key);
            if (!(parameter instanceof String)) {
                resolvedParameters.put(key, parameter);
                continue;
            }
            String resolvedParameter = this.resolveParameter((String)parameter);
            resolvedParameters.put(key, resolvedParameter);
        }
        return resolvedParameters;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setObjectModel(ObjectModel objectModel) {
        this.objectModel = objectModel;
    }

    public class VariableNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VariableNotFoundException(String msg) {
            super(msg);
        }
    }

    public class UnsupportedExpressionLanguageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnsupportedExpressionLanguageException(String msg) {
            super(msg);
        }
    }
}

