/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.statistics.aspects;

import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.monitoring.statistics.StatisticsCollector;
import org.apache.cocoon.monitoring.statistics.StatisticsEnabled;
import org.apache.cocoon.monitoring.statistics.StatisticsSourceEnabled;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class UrlHitCountStatisticsAspect
implements StatisticsEnabled {
    private final StatisticsCollector collector;

    public UrlHitCountStatisticsAspect() {
        this(86400000L, 10000L);
    }

    public UrlHitCountStatisticsAspect(long maxKeepTime, long refreshDelaty) {
        this.collector = new StatisticsCollector(maxKeepTime, refreshDelaty);
    }

    @Around(value="execution(* service(..)) && target(javax.servlet.Servlet) && args(req, ..)")
    public Object handleUrlRequest(ProceedingJoinPoint pjp, HttpServletRequest req) throws Throwable {
        String className = pjp.getTarget().getClass().getName();
        if (!className.startsWith("$Proxy")) {
            this.collector.incerementCounter(req.getRequestURI());
        }
        return pjp.proceed(pjp.getArgs());
    }

    public StatisticsSourceEnabled getStatistics() {
        return this.collector;
    }

    public String statisticsSourceName() {
        return "UrlHitCount";
    }
}

