/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.statistics.aspects;

import org.apache.cocoon.monitoring.statistics.StatisticsCollector;
import org.apache.cocoon.monitoring.statistics.StatisticsEnabled;
import org.apache.cocoon.monitoring.statistics.StatisticsSourceEnabled;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class ServletHitCountStatisticsAspect
implements StatisticsEnabled {
    private final StatisticsCollector collector;

    public ServletHitCountStatisticsAspect() {
        this(86400000L, 10000L);
    }

    public ServletHitCountStatisticsAspect(long maxKeepTime, long refreshDelaty) {
        this.collector = new StatisticsCollector(maxKeepTime, refreshDelaty);
    }

    @Around(value="execution(* service(..)) && target(javax.servlet.Servlet))")
    public Object handleServletRequest(ProceedingJoinPoint pjp) throws Throwable {
        String className = pjp.getTarget().getClass().getName();
        if (!className.startsWith("$Proxy")) {
            this.collector.incerementCounter(className);
        }
        return pjp.proceed(pjp.getArgs());
    }

    public StatisticsSourceEnabled getStatistics() {
        return this.collector;
    }

    public String statisticsSourceName() {
        return "ServletHitCount";
    }
}

