/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.statistics.aspects;

import org.apache.cocoon.monitoring.statistics.StatisticsCollector;
import org.apache.cocoon.monitoring.statistics.StatisticsEnabled;
import org.apache.cocoon.monitoring.statistics.StatisticsSourceEnabled;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class CacheStatisticsAspect
implements StatisticsEnabled {
    private final StatisticsCollector collector;

    public CacheStatisticsAspect() {
        this(86400000L, 10000L);
    }

    public CacheStatisticsAspect(long maxKeepTime, long refreshDelay) {
        this.collector = new StatisticsCollector(maxKeepTime, refreshDelay);
    }

    @After(value="execution(* put(..)) && target(org.apache.cocoon.pipeline.caching.Cache) && args(key, ..)")
    public void handleCachePutRequest(CacheKey key) throws Throwable {
        this.collector.putKey(key.toString());
    }

    @After(value="execution(* get(..)) && target(org.apache.cocoon.pipeline.caching.Cache) && args(key, ..)")
    public void handleCacheGetRequest(CacheKey key) throws Throwable {
        this.collector.incerementCounter(key.toString());
    }

    public StatisticsSourceEnabled getStatistics() {
        return this.collector;
    }

    public String statisticsSourceName() {
        return "CacheHitCount";
    }
}

