/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.statistics;

import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cocoon.monitoring.statistics.Statistics;
import org.apache.cocoon.monitoring.statistics.StatisticsEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.MBeanExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsInitializer {
    private final Log logger = LogFactory.getLog(this.getClass());

    public StatisticsInitializer(Map<String, StatisticsEnabled> statsSources, MBeanExporter exporter) {
        for (StatisticsEnabled stat : statsSources.values()) {
            ObjectName name;
            String stringName = "org.apache.cocoon:group=Statistics,name=" + stat.statisticsSourceName();
            try {
                name = new ObjectName(stringName);
            }
            catch (MalformedObjectNameException e) {
                this.logger.error((Object)("Invalid name of manager resource: " + stringName), (Throwable)e);
                continue;
            }
            catch (NullPointerException e) {
                this.logger.error((Object)"Should never happened. Value of name parameter always is different than null.", (Throwable)e);
                continue;
            }
            exporter.registerManagedResource((Object)new Statistics(stat), name);
        }
    }
}

