/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cocoon.monitoring.statistics.StatisticsSourceEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsCollector
implements StatisticsSourceEnabled {
    public static final long DEFAULT_REFRESH_DELAY = 10000L;
    public static final long DEFAULT_MAX_KEEP_TIME = 86400000L;
    private final Map<String, Double> allHitCount;
    private final Map<String, List<Long>> coutners;
    private final long maxKeepTime;

    public StatisticsCollector() {
        this(86400000L, 10000L);
    }

    public StatisticsCollector(long maxKeepTime, long refreshDelay) {
        this.maxKeepTime = maxKeepTime;
        this.allHitCount = Collections.synchronizedMap(new HashMap());
        this.coutners = Collections.synchronizedMap(new HashMap());
        this.initCleaningThread(refreshDelay);
    }

    @Override
    public Map<String, Double> getHits() {
        return new HashMap<String, Double>(this.allHitCount);
    }

    @Override
    public Map<String, Long> getHits(long time) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        long timeBorder = new Date().getTime() - time;
        for (String key : this.coutners.keySet()) {
            long sum = 0L;
            for (long item : this.coutners.get(key)) {
                if (item <= timeBorder) continue;
                ++sum;
            }
            result.put(key, sum);
        }
        return result;
    }

    @Override
    public double getHitCount(String key) {
        return this.allHitCount.containsKey(key) ? this.allHitCount.get(key) : 0.0;
    }

    @Override
    public double getHitCountSum() {
        double result = 0.0;
        for (Double count : this.allHitCount.values()) {
            result += count.doubleValue();
        }
        return result;
    }

    @Override
    public long getRequestCount(String key, long time) {
        if (!this.coutners.containsKey(key)) {
            return 0L;
        }
        List<Long> counter = this.coutners.get(key);
        long hitCount = 0L;
        long currentTimestamp = new Date().getTime() - time;
        for (Long timestamp : counter) {
            if (timestamp <= 0L || currentTimestamp >= timestamp) continue;
            ++hitCount;
        }
        return hitCount;
    }

    public void putKey(String key) {
        this.insertDataIntoCounter(key, -1L);
    }

    public void incerementCounter(String key) {
        this.insertDataIntoCounter(key, new Date().getTime());
    }

    private void insertDataIntoCounter(String key, long data) {
        if (!this.coutners.containsKey(key)) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(data);
            this.coutners.put(key, list);
        } else {
            this.coutners.get(key).add(data);
        }
        if (this.allHitCount.containsKey(key) && data > 0L) {
            this.allHitCount.put(key, this.allHitCount.get(key) + 1.0);
        } else if (data > 0L) {
            this.allHitCount.put(key, 1.0);
        } else {
            this.allHitCount.put(key, 0.0);
        }
    }

    private void initCleaningThread(long refreshDelay) {
        Timer cleaningTimer = new Timer("RequestCounterCleaningTask", true);
        cleaningTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                ArrayList<Long> toRemove = new ArrayList<Long>();
                long currentTimestamp = new Date().getTime();
                for (List counter : StatisticsCollector.this.coutners.values()) {
                    for (Long timestamp : counter) {
                        if (timestamp <= 0L || currentTimestamp - timestamp <= StatisticsCollector.this.maxKeepTime) continue;
                        toRemove.add(timestamp);
                    }
                    counter.removeAll(toRemove);
                    toRemove.clear();
                }
            }
        }, refreshDelay, refreshDelay);
    }
}

