/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.statistics;

import java.util.Map;
import org.apache.cocoon.monitoring.statistics.StatisticsEnabled;
import org.apache.cocoon.monitoring.statistics.StatisticsSourceEnabled;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class Statistics {
    private final StatisticsSourceEnabled stats;

    public Statistics(StatisticsEnabled stats) {
        this.stats = stats.getStatistics();
    }

    @ManagedAttribute(description="Returns all hit count since system start.")
    public double getAllHitCount() {
        return this.stats.getHitCountSum();
    }

    @ManagedAttribute(description="Returns a map of all hits and their counts.")
    public Map<String, Double> getHits() {
        return this.stats.getHits();
    }

    @ManagedOperation(description="Returns a map of all hits and their counts limited by a time parameter.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="time", description="Time in miliseconds.")})
    public Map<String, Long> getHits(long time) {
        return this.stats.getHits(time);
    }
}

