/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.servletservice;

import java.util.ArrayList;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cocoon.monitoring.servletservice.ServletServiceMonitor;
import org.apache.cocoon.servletservice.ServletServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.MBeanExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletServiceMonitorInitializer {
    private final Log logger = LogFactory.getLog(this.getClass());

    public ServletServiceMonitorInitializer(Map<String, Servlet> servlets, MBeanExporter exporter) {
        ArrayList<String> servletNames = new ArrayList<String>();
        for (Servlet servlet : servlets.values()) {
            ServletConfig servletConfig = servlet.getServletConfig();
            ServletContext servletContext = servletConfig.getServletContext();
            String servletName = servletConfig.getServletName();
            if (!(servletContext instanceof ServletServiceContext)) {
                this.logger.info((Object)(servletName + " isn't Servlet-Service servlet, it will be ignored."));
                continue;
            }
            ServletServiceContext servletServiceContext = (ServletServiceContext)servletContext;
            ObjectName name = null;
            String stringName = "org.apache.cocoon:group=ServletServices,name=[" + this.getMountPath(servletServiceContext) + "] " + servletName;
            try {
                name = new ObjectName(stringName);
            }
            catch (MalformedObjectNameException e) {
                this.logger.error((Object)"The string passed as a parameter does not have the right format.", (Throwable)e);
                continue;
            }
            catch (NullPointerException e) {
                this.logger.fatal((Object)"Should never happened. Value of name parameter always is different than null.", (Throwable)e);
                continue;
            }
            if (name == null) {
                this.logger.error((Object)"ObjectName is null, something strange happen. Should never happen.");
                continue;
            }
            ServletServiceMonitor servletServiceMonitor = new ServletServiceMonitor(servlet);
            if (servletNames.contains(stringName)) continue;
            exporter.registerManagedResource((Object)servletServiceMonitor, name);
            servletNames.add(stringName);
        }
    }

    private String getMountPath(ServletServiceContext servletServiceContext) {
        String mountPath = servletServiceContext.getMountPath();
        if (mountPath != null && !mountPath.startsWith("/")) {
            return "/" + mountPath;
        }
        if (mountPath == null) {
            return "not mounted";
        }
        return mountPath;
    }
}

