/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.servletservice;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cocoon.servletservice.ServletServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class ServletServiceMonitor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Servlet servlet;

    public ServletServiceMonitor(Servlet servlet) {
        this.servlet = servlet;
    }

    @ManagedAttribute(description="Returns all ServletService init parameters")
    public String[] getServletServiceInitParameters() {
        ServletConfig config = this.servlet.getServletConfig();
        Enumeration initParameterNames = config.getInitParameterNames();
        ArrayList<String> result = new ArrayList<String>();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            String parameter = config.getInitParameter(name);
            if (parameter == null) continue;
            result.add(name + " = " + parameter);
        }
        return result.toArray(new String[0]);
    }

    @ManagedAttribute(description="Returns list of connections for this Servlet-Service")
    public final String[] getServletServiceConnections() {
        ServletContext servletContext = this.servlet.getServletConfig().getServletContext();
        ServletServiceContext servletServiceContext = (ServletServiceContext)servletContext;
        Map servletServiceConnections = null;
        try {
            Field connectionsField = servletServiceContext.getClass().getDeclaredField("connectionServiceNames");
            connectionsField.setAccessible(true);
            servletServiceConnections = (Map)connectionsField.get(ServletServiceMonitor.unpackProxy(servletServiceContext));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Can't access the connections field of " + servletContext + "."), (Throwable)e);
        }
        if (servletServiceConnections != null) {
            String[] connections = new String[servletServiceConnections.size()];
            int i = 0;
            for (String key : servletServiceConnections.keySet()) {
                connections[i] = key + " = " + (String)servletServiceConnections.get(key);
                ++i;
            }
            return connections;
        }
        return new String[0];
    }

    @ManagedAttribute(description="Returns information about this Servlet-Service")
    public final String getServletServiceInfo() {
        return this.servlet.getServletInfo();
    }

    @ManagedAttribute(description="Returns list of registered Servlet-Services with their month paths")
    public final String getServletServiceMountPaths() {
        ServletContext servletContext = this.servlet.getServletConfig().getServletContext();
        ServletServiceContext context = (ServletServiceContext)servletContext;
        return context.getMountPath();
    }

    private static <T> T unpackProxy(T proxy) throws Exception {
        if (proxy instanceof Advised) {
            Advised advised = (Advised)proxy;
            return (T)advised.getTargetSource().getTarget();
        }
        return proxy;
    }
}

