/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.reconfiguration;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggingConfigurationResetter {
    private final long delay;
    private final Logger logger;
    private final Level oldLogLevel;

    public LoggingConfigurationResetter(Logger logger, Level oldLevel, String timeout) {
        long factor;
        this.logger = logger;
        this.oldLogLevel = oldLevel;
        char unit = timeout.charAt(timeout.length() - 1);
        switch (unit) {
            case 's': {
                factor = 1000L;
                break;
            }
            case 'm': {
                factor = 60000L;
                break;
            }
            case 'h': {
                factor = 3600000L;
                break;
            }
            case 'd': {
                factor = 86400000L;
                break;
            }
            default: {
                String message = "Unsupported unit: " + unit;
                throw new UnsupportedOperationException(message);
            }
        }
        float multipler = Float.parseFloat(timeout.substring(0, timeout.length() - 1));
        this.delay = Math.round(multipler * (float)factor);
    }

    public void start() {
        TimerTask task = new TimerTask(){

            public void run() {
                LoggingConfigurationResetter.this.logger.setLevel(LoggingConfigurationResetter.this.oldLogLevel);
            }

            public boolean cancel() {
                this.run();
                return super.cancel();
            }
        };
        Timer timer = new Timer("Restore " + this.logger.getName() + " to level" + this.oldLogLevel, true);
        timer.schedule(task, this.delay);
    }
}

