/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.reconfiguration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import javax.naming.ConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cocoon.configuration.PropertyHelper;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.monitoring.reconfiguration.LoggingConfigurationResetter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

@ManagedResource(objectName="org.apache.cocoon:group=Reconfiguration,name=Log4JReconfigurator")
public class Log4JReconfigurator {
    private static final String[] EXTENSIONS = new String[]{"xml", "properties"};
    private final Logger logger;
    private final LoggerRepository loggerRepository = LogManager.getLoggerRepository();
    private final DocumentBuilder docBuilder;
    private Settings settings;

    public Log4JReconfigurator() {
        this.logger = Logger.getLogger(Log4JReconfigurator.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.docBuilder.setErrorHandler(new DefaultHandler());
        this.docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
    }

    @ManagedAttribute(description="Return a list of all configured loggers with their level.")
    public final String[] getLoggers() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration currentLoggers = this.loggerRepository.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            Logger tmpLogger = (Logger)currentLoggers.nextElement();
            if (tmpLogger.getLevel() == null) continue;
            result.add(tmpLogger.getName() + ": " + tmpLogger.getLevel());
        }
        return result.toArray(new String[0]);
    }

    @ManagedOperation(description="Sets logging level for a particular package or a class. Returns true if operation was successful.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="category", description="Name of the log category (usually a package or class name) whose log level should be changed."), @ManagedOperationParameter(name="newLevel", description="New log level for that category. Available log levels are: OFF, INFO, WARN, ERROR, FATAL, TRACE, DEBUG, ALL")})
    public final boolean setLoggingLevel(String category, String newLogLevel) {
        boolean result = false;
        Logger logger = this.loggerRepository.getLogger(category);
        if (logger != null) {
            logger.setLevel(Level.toLevel((String)newLogLevel.toUpperCase()));
            result = true;
        }
        return result;
    }

    @ManagedOperation(description="Sets new logging level for amount of time. After timeout log level is set back to old value.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="category", description="Name of the log category (usually a package or class name) whose log level should be changed."), @ManagedOperationParameter(name="temporalLevel", description="Temporal log level for that category that should be set for specified amount of time."), @ManagedOperationParameter(name="timeOut", description="Amount of time that temporalLevel should be active. Value of timeOut should match regular expression: ^[0-9.]+[dhm]?$ where 'd' means day, 'h' hours and 'm' minutes")})
    public final boolean setLoggingTempoporalLevel(String category, String temporalLogLevel, String timeOut) {
        if (!timeOut.matches("^[0-9.]+[dhm]?$")) {
            throw new UnsupportedOperationException("Unsupported time-out format: " + timeOut);
        }
        boolean result = false;
        Logger logger = this.loggerRepository.getLogger(category);
        if (logger != null) {
            Level oldLevel = logger.getLevel();
            LoggingConfigurationResetter restoreThread = new LoggingConfigurationResetter(logger, oldLevel, timeOut.toLowerCase());
            logger.setLevel(Level.toLevel((String)temporalLogLevel));
            restoreThread.start();
            result = true;
        }
        return result;
    }

    @ManagedOperation(description="Allows to change configuration of log4j on the fly. This function support both XML and properties configuration files. Before reloading configuration it checks that the new config file contains at least one appender and all output files are accessible (for XML configs italso validate XML syntax using schema or DTD)")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="configFilePath", description="Absolute path to configuration file.")})
    public final boolean loadNewConfigurationFile(String path) throws Exception {
        if (FilenameUtils.isExtension((String)(path = path.trim()), (String[])EXTENSIONS)) {
            File newConfig = new File(path);
            if (!newConfig.exists()) {
                this.logger.fatal((Object)("Cannot find file: " + path));
                throw new FileNotFoundException("Cannot find file: " + path);
            }
            if (!newConfig.canRead()) {
                this.logAndThrowIOException("Cannot read file: " + path);
            }
            if (FilenameUtils.isExtension((String)path, (String)"xml")) {
                this.loadNewXMLConfigurationFile(path);
            } else {
                this.loadNewPropertiesConfigurationFile(path);
            }
        } else {
            String message = "Unsupported file format: " + FilenameUtils.getExtension((String)path);
            this.logger.fatal((Object)message);
            throw new ConfigurationException(message);
        }
        return true;
    }

    public final void setSettings(Settings s) {
        this.settings = s;
    }

    private void loadNewXMLConfigurationFile(String path) throws Exception {
        Document doc;
        try {
            doc = this.docBuilder.parse(path);
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new IOException("Config file parse exception: " + e.getMessage());
        }
        NodeList appenderList = doc.getElementsByTagName("appender");
        for (int i = 0; i < appenderList.getLength(); ++i) {
            NodeList childNodes = appenderList.item(i).getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node item = childNodes.item(j);
                this.extractLogFilespathAndValidate(item);
            }
        }
        DOMConfigurator.configure((String)path);
    }

    private void extractLogFilespathAndValidate(Node item) throws IOException {
        Node paramValue;
        if (!item.getNodeName().equalsIgnoreCase("param")) {
            return;
        }
        NamedNodeMap itemAttributes = item.getAttributes();
        if (itemAttributes == null) {
            return;
        }
        Node paramName = itemAttributes.getNamedItem("name");
        if (paramName != null && paramName.getNodeValue().equalsIgnoreCase("file") && (paramValue = itemAttributes.getNamedItem("value")) != null) {
            String logpath = paramValue.getNodeValue();
            this.validateLogFile(logpath);
        }
    }

    private void loadNewPropertiesConfigurationFile(String path) throws ConfigurationException, IOException {
        boolean result = false;
        File file = new File(path);
        Scanner fileScanner = new Scanner(file);
        while (fileScanner.hasNext()) {
            String line = fileScanner.nextLine();
            if (!result && line.toLowerCase().matches("^log4j\\.appender\\.[\\w\\.]+=[\\w\\.]+$")) {
                PropertyConfigurator.configure((String)file.getPath());
                result = true;
            }
            if (!line.toLowerCase().matches("^log4j\\.appender\\.[\\w]+\\.file=[\\w\\.\\{\\}\\$/\\:]+$")) continue;
            String[] logFile = line.split("=");
            this.validateLogFile(logFile[1]);
        }
        if (!result) {
            throw new ConfigurationException("No configured appenders, there should be at least one appender confgured.");
        }
    }

    private void logAndThrowIOException(String message) throws IOException {
        this.logger.fatal((Object)message);
        throw new IOException(message);
    }

    private void validateLogFile(String logPath) throws IOException {
        String logDirpath = FilenameUtils.getFullPath((String)PropertyHelper.replace((String)logPath, (Settings)this.settings));
        if (logDirpath.length() == 0) {
            logDirpath = ".";
        }
        if (!new File(logDirpath).exists()) {
            this.logAndThrowIOException("Log directory: " + logDirpath + " does not exist.");
        } else if (!new File(logPath).canWrite()) {
            this.logAndThrowIOException("Log file: " + logPath + " is read only.");
        }
    }
}

