/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.reconfiguration;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.cocoon.configuration.MutableSettings;
import org.apache.cocoon.configuration.Settings;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(objectName="org.apache.cocoon:group=Reconfiguration,name=JmxSpringSettings")
public class JmxSpringSettings {
    private final MutableSettings settings;

    public JmxSpringSettings(Settings settings) {
        this.settings = (MutableSettings)settings;
    }

    @ManagedOperation(description="Get the value of a property.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="key", description="The name of the property.")})
    public final String getProperty(String key) {
        return this.settings.getProperty(key);
    }

    @ManagedOperation(description="Return all available property names starting with the prefix.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="keyPrefix", description="The prefix each property name must have.")})
    public final String[] listPropertys(String keyPrefix) {
        return this.getProperties(this.settings.getPropertyNames(keyPrefix));
    }

    @ManagedOperation(description="Return all available property names.")
    public final String[] listPropertys() {
        return this.getProperties(this.settings.getPropertyNames());
    }

    @ManagedAttribute(description="List classes that should be loaded at initialization time of the servlet.")
    public final String[] listLoadClasses() {
        return this.settings.getLoadClasses().toArray(new String[0]);
    }

    @ManagedAttribute(description="The character set used to decode request parameters.")
    public final String getFormEncoding() {
        return this.settings.getFormEncoding();
    }

    @ManagedAttribute(description="Encoding used by the container.")
    public final String getContainerEncoding() {
        return this.settings.getContainerEncoding();
    }

    @ManagedAttribute(description="Specify where Cocoon should create its page and other objects cache. The path specified can be either absolute or relative to the context path of the servlet.")
    public final String getCacheDirectory() {
        return this.settings.getCacheDirectory();
    }

    @ManagedAttribute(description="The creation time of the current settings instance.")
    public final String getCreationTime() {
        return new Date(this.settings.getCreationTime()).toString();
    }

    @ManagedOperation(description="This method can be used by components to query if they are configured to check for reloading.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="type", description="The type of the component that wants to check for reload.")})
    public final boolean isReloadingEnabled(String type) {
        return this.settings.isReloadingEnabled(type);
    }

    @ManagedOperation(description="This method can be used by components to get the configured delay period between checks.")
    public final long getReloadingDelay(String type) {
        return this.settings.getReloadDelay(type);
    }

    @ManagedAttribute(description="Return the current running mode.")
    public final String getRunningMode() {
        return this.settings.getRunningMode();
    }

    @ManagedOperation(description="Sets new value of property. (Note: This change is not persistant!)")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="key", description="Property key that value should be changed."), @ManagedOperationParameter(name="value", description="New value of property.")})
    public final void setProperty(String key, String value) {
        Properties props = new Properties();
        props.put(key, value);
        this.settings.configure(props);
    }

    @ManagedOperation(description="Sets form encoding'. (Note: This change is not persistant!)")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="formEncoding", description="The formEncoding to set.")})
    public final void setFormEncoding(String formEncoding) {
        this.settings.setFormEncoding(formEncoding);
    }

    @ManagedOperation(description="Set the container encoding.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="encofing", description="The new encoding value.")})
    public final void setContainerEncoding(String encoding) {
        this.settings.setContainerEncoding(encoding);
    }

    @ManagedOperation(description="Allow reloading. (Note: This change is not persistant!)")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="allowReload", description="The allowReload to set.")})
    public final void setReloadingEnabled(boolean allowReload) {
        this.settings.setReloadingEnabled(allowReload);
    }

    private String[] getProperties(List<String> propertyNames) {
        String[] result = new String[propertyNames.size()];
        for (int i = 0; i < propertyNames.size(); ++i) {
            String key = propertyNames.get(i);
            result[i] = key + ": " + this.settings.getProperty(key);
        }
        return result;
    }
}

