/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.cache.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cocoon.monitoring.cache.entry.CacheEntryMonitor;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(objectName="org.apache.cocoon:group=Cache,name=CacheEntrysRefresher")
public class CacheEntrysMonitorInitializer {
    private static final String namePrefix = "org.apache.cocoon:group=Cache,subGroup=Entrys,groupName=";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MBeanServer mBeanServer;
    private final MBeanExporter mBeanExporter;
    private final Map<String, Cache> caches;
    private final List<ObjectName> registerdMBeans;
    private Timer autoRefreshTimer;

    public CacheEntrysMonitorInitializer(Map<String, Cache> caches, MBeanExporter exporter) {
        this(caches, exporter, 0L);
    }

    public CacheEntrysMonitorInitializer(Map<String, Cache> caches, MBeanExporter exporter, long refreshTimeOut) {
        this.caches = caches;
        this.mBeanExporter = exporter;
        this.mBeanServer = exporter.getServer();
        this.registerdMBeans = new ArrayList<ObjectName>();
        if (refreshTimeOut > 0L) {
            this.enableAutoRefresh(refreshTimeOut);
        }
    }

    @ManagedOperation(description="Forces refresh action on CachesEntrys monitor.")
    public final boolean performRefresh() {
        List<ObjectName> toRemove = this.processCaches(this.caches);
        for (ObjectName objectName : toRemove) {
            if (!this.mBeanServer.isRegistered(objectName)) continue;
            try {
                this.mBeanServer.unregisterMBean(objectName);
            }
            catch (MBeanRegistrationException e) {
                this.logger.fatal((Object)e.getMessage(), (Throwable)e);
                return false;
            }
            catch (InstanceNotFoundException e) {
                this.logger.fatal((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @ManagedOperation(description="Enables auto refresh action. If there is already refresh action started it would be  stopped and started new refresh action with defined refreshTimeOut parameter.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="refreshTimeOut", description="Refresh operation time out in milliseconds.")})
    public final void enableAutoRefresh(long refreshTimeOut) {
        if (this.autoRefreshTimer != null) {
            this.disableAutoRefresh();
        }
        this.autoRefreshTimer = new Timer(true);
        this.autoRefreshTimer.scheduleAtFixedRate((TimerTask)new RefreshTask(), 0L, refreshTimeOut);
    }

    @ManagedOperation(description="Stops refresh action if there is any refresh action already running.")
    public final void disableAutoRefresh() {
        if (this.autoRefreshTimer != null) {
            this.autoRefreshTimer.cancel();
            this.autoRefreshTimer.purge();
            this.autoRefreshTimer = null;
        }
    }

    private List<ObjectName> processCaches(Map<String, Cache> caches) {
        ArrayList<ObjectName> objectsToBeRemoved = new ArrayList<ObjectName>(this.registerdMBeans);
        this.registerdMBeans.clear();
        for (Cache cache : caches.values()) {
            for (CacheKey cacheKey : cache.keySet()) {
                ObjectName objectName;
                if (!cacheKey.hasJmxGroupName()) continue;
                String cacheType = cacheKey.getClass().getSimpleName();
                String cacheName = cacheKey.toString().replaceAll("[=:,]", "_");
                String fullObjectName = namePrefix + cacheKey.getJmxGroupName() + ",cacheType=" + cacheType + ",name=" + cacheName;
                try {
                    objectName = new ObjectName(fullObjectName);
                }
                catch (MalformedObjectNameException e) {
                    this.logger.error((Object)("Invalid name of manager resource: " + fullObjectName), (Throwable)e);
                    continue;
                }
                catch (NullPointerException e) {
                    this.logger.error((Object)"Should never happened. Value of name parameter always is different than null.", (Throwable)e);
                    continue;
                }
                if (!this.mBeanServer.isRegistered(objectName)) {
                    this.mBeanExporter.registerManagedResource((Object)new CacheEntryMonitor(cacheKey, cache.get(cacheKey)), objectName);
                }
                this.registerdMBeans.add(objectName);
                objectsToBeRemoved.remove(objectName);
            }
        }
        return objectsToBeRemoved;
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        public void run() {
            CacheEntrysMonitorInitializer.this.performRefresh();
        }
    }
}

