/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.cache.entry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.cocoon.monitoring.util.UnitSizeFormatter;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheValue;
import org.apache.cocoon.pipeline.caching.CompleteCacheValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class CacheEntryMonitor {
    private final CacheKey cacheKey;
    private final CacheValue cacheValue;
    private final Log logger = LogFactory.getLog(this.getClass());

    public CacheEntryMonitor(CacheKey cacheKey, CacheValue cacheValue) {
        this.cacheKey = cacheKey;
        this.cacheValue = cacheValue;
    }

    @ManagedAttribute(description="Retuns tihs cache value key.")
    public final String getCacheKey() {
        return this.cacheKey.toString();
    }

    @ManagedAttribute(description="Returns content of this cache entry.")
    public final String getCacheValue() {
        if (this.cacheValue instanceof CompleteCacheValue) {
            ByteArrayOutputStream test = new ByteArrayOutputStream();
            try {
                this.cacheValue.writeTo((OutputStream)test);
            }
            catch (IOException e) {
                this.logger.fatal((Object)e.getMessage(), (Throwable)e);
                return "IOException occurs, please check logs.";
            }
            return new String(test.toByteArray());
        }
        return String.valueOf(this.cacheValue.getValue());
    }

    @ManagedOperation(description="Sets value of this cache entry.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="value", description="New value of cache.")})
    public final boolean setCacheValue(String value) {
        this.cacheValue.setValue((Object)value);
        return true;
    }

    @ManagedAttribute(description="Returns size of this cache entry.")
    public final String getSize() {
        return UnitSizeFormatter.getHumanReadableSize(this.cacheValue.size());
    }
}

