/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.cache;

import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cocoon.monitoring.cache.CacheMonitor;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.MBeanExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMonitorInitializer {
    private final Log logger = LogFactory.getLog(this.getClass());

    public CacheMonitorInitializer(Map<String, Cache> caches, MBeanExporter exporter) {
        for (Cache cache : caches.values()) {
            ObjectName name;
            String stringName = "org.apache.cocoon:group=Cache,subGroup=Caches,name=" + cache.toString().replace("=", " ");
            try {
                name = new ObjectName(stringName);
            }
            catch (MalformedObjectNameException e) {
                this.logger.error((Object)("Invalid name of manager resource: " + stringName), (Throwable)e);
                continue;
            }
            catch (NullPointerException e) {
                this.logger.error((Object)"Should never happened. Value of name parameter always is different than null.", (Throwable)e);
                continue;
            }
            exporter.registerManagedResource((Object)new CacheMonitor(cache), name);
        }
    }
}

