/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.cache;

import java.util.Set;
import org.apache.cocoon.monitoring.util.UnitSizeFormatter;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheValue;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class CacheMonitor {
    private final Cache cache;

    public CacheMonitor(Cache cache) {
        this.cache = cache;
    }

    @ManagedOperation(description="Removes all cached data.")
    public final void clear() {
        this.cache.clear();
    }

    @ManagedOperation(description="Removes all cached data.")
    public final String[] listKeys() {
        Set keySet = this.cache.keySet();
        String[] result = new String[keySet.size()];
        int i = 0;
        for (CacheKey cacheKey : keySet) {
            result[i++] = cacheKey.toString();
        }
        return result;
    }

    @ManagedOperation(description="Remove specific key for cache")
    @ManagedOperationParameter(name="cacheKeyName", description="Name of CacheKey with should be removed")
    public final boolean removeKey(String cacheKeyName) {
        Set keySet = this.cache.keySet();
        for (CacheKey cacheKey : keySet) {
            if (!cacheKey.equals(cacheKeyName)) continue;
            this.cache.remove(cacheKey);
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Returns size of this cache")
    public final String size() {
        double result = 0.0;
        for (CacheKey key : this.cache.keySet()) {
            double size;
            CacheValue cacheValue = this.cache.get(key);
            if (cacheValue == null || (size = cacheValue.size()) == -1.0) continue;
            result += size;
        }
        return UnitSizeFormatter.getHumanReadableSize(result);
    }
}

