/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.monitoring.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheValue;
import org.apache.cocoon.pipeline.caching.ExpiresCacheKey;
import org.apache.commons.lang.StringUtils;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(objectName="org.apache.cocoon:group=Cache,name=CacheBurstActions", description="This module can perform burst operation (like cleaning specified cache elements) on all cache data.")
public class CacheBurstActions {
    private final List<Cache> caches;

    public CacheBurstActions(Map<String, Cache> caches) {
        this.caches = new ArrayList<Cache>(caches.values());
    }

    @ManagedOperation(description="Clears all cache entry's that size is greater that minSize parameter.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="minSize", description="Minimal size (in bytes) of cache entry that should be cleaned.")})
    public final boolean clearAllGreaterThen(long minSize) {
        return this.clear(minSize, -1L, null, null, null, null);
    }

    @ManagedOperation(description="Clears all cache entry's that size is smaller than maxSize parameter.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="maxSize", description="Maximum size (in bytes) of cache entry that should be cleaned.")})
    public final boolean clearAllSmallerThen(long maxSize) {
        return this.clear(-1L, maxSize, null, null, null, null);
    }

    @ManagedOperation(description="Clears all cache entry's that are older than baseDate parameter.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="baseDate", description="")})
    public final boolean clearAllOlderThen(String baseDate) {
        return this.clear(-1L, -1L, baseDate, null, null, null);
    }

    @ManagedOperation(description="Clears all cache entry's that are younger than baseDate parameter.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="baseDate", description="")})
    public final boolean clearAllYoungerThen(String baseDate) {
        return this.clear(-1L, -1L, null, baseDate, null, null);
    }

    @ManagedOperation(description="Clears all cache entry's that matches all conditions in parameters. All parameters are connected logical AND, so to perform action cache entry should match all conditions at once.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="minSize", description="Minimal size (in bytes) of cache entry that should be cleaned. If value of this parameter < 0 then it isn't consider."), @ManagedOperationParameter(name="maxSize", description="Maximum size (in bytes) of cache entry that should be cleaned. If value of this parameter < 0 then it isn't consider."), @ManagedOperationParameter(name="minLastModifyDate", description="If this parameter is null or is empty it isn't consider."), @ManagedOperationParameter(name="maxLastModifyDate", description="If this parameter is null or is empty it isn't consider."), @ManagedOperationParameter(name="minExpiresDate", description="This parameter apply's only to ExpiresCacheKey entry's. If this parameter is null or is empty it isn't consider."), @ManagedOperationParameter(name="maxExpiresDate", description="This parameter apply's only to ExpiresCacheKey entry's. If this parameter is null or is empty it isn't consider.")})
    public final boolean clear(long minSize, long maxSize, String minLastModifyDate, String maxLastModifiDate, String minExpiresDate, String maxExpiresDate) {
        final AtomicBoolean state = new AtomicBoolean(true);
        this.performActionOnCaches(minSize, maxSize, minLastModifyDate, maxLastModifiDate, minExpiresDate, maxExpiresDate, new CacheAction(){

            public void performAction(Cache cache, CacheKey cacheKey) {
                if (state.get()) {
                    boolean tmp = cache.remove(cacheKey);
                    state.set(tmp);
                }
            }
        });
        return state.get();
    }

    @ManagedOperation(description="List all cache entry's that size is greater then minSize parameter. You should use this operation just before performing clearAllGreaterThen() to check what entry's would be cleaned. Returned list is limited to first 100 entry's.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="minSize", description="Minimal size (in bytes) of cache entry.")})
    public final String[] listAllGreaterThen(long minSize) {
        return this.list(minSize, -1L, null, null, null, null);
    }

    @ManagedOperation(description="List all cache entry's that size is smaller then minSize parameter. You should use this operation just before performing clearAllSmallerThen() to check what entry's would be cleaned. Returned list is limited to first 100 entry's.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="maxSize", description="Maximum size (in bytes) of cache entry.")})
    public final String[] listAllSmallerThen(long maxSize) {
        return this.list(-1L, maxSize, null, null, null, null);
    }

    @ManagedOperation(description="List all cache entry's that older than baseDate parameter. You should use this operation just before performing clearAllOlderThen() to check what entry's would be cleaned. Returned list is limited to first 100 entry's.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="baseDate", description="")})
    public final String[] listAllOlderThen(String baseDate) {
        return this.list(-1L, -1L, baseDate, null, null, null);
    }

    @ManagedOperation(description="List all cache entry's that younger than baseDate parameter. You should use this operation just before performing clearAllYoungerThen() to check what entry's would be cleaned. Returned list is limited to first 100 entry's.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="baseDate", description="")})
    public final String[] listAllYoungerThen(String baseDate) {
        return this.list(-1L, -1L, baseDate, null, null, null);
    }

    @ManagedOperation(description="List all cache entry's that that matches all conditions in parameters. All parameters are connected logical AND, so to perform action cache entry should match all conditions at once. You should use this operation just before performing clear() to check what entry's would be cleaned. Returned list is limited to first 100 entry's.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="minSize", description="Minimal size (in bytes) of cache entry. If value of this parameter < 0 then it isn't consider."), @ManagedOperationParameter(name="maxSize", description="Maximum size (in bytes) of cache entry. If value of this parameter < 0 then it isn't consider."), @ManagedOperationParameter(name="minLastModifyDate", description="If this parameter is null or is empty it isn't consider."), @ManagedOperationParameter(name="maxLastModifyDate", description="If this parameter is null or is empty it isn't consider."), @ManagedOperationParameter(name="minExpiresDate", description="This parameter apply's only to ExpiresCacheKey entry's. If this parameter is null or is empty it isn't consider."), @ManagedOperationParameter(name="maxExpiresDate", description="This parameter apply's only to ExpiresCacheKey entry's. If this parameter is null or is empty it isn't consider.")})
    public final String[] list(long minSize, long maxSize, String minLastModifyDate, String maxLastModifiDate, String minExpiresDate, String maxExpiresDate) {
        List<String> returnList;
        final ArrayList results = new ArrayList();
        this.performActionOnCaches(minSize, maxSize, minLastModifyDate, maxLastModifiDate, minExpiresDate, maxExpiresDate, new CacheAction(){

            public void performAction(Cache cache, CacheKey cacheKey) {
                results.add(cache.toString() + cacheKey.toString());
            }
        });
        if (results.size() > 100) {
            returnList = results.subList(0, 99);
            returnList.add("There is " + (results.size() - 100) + " more elements that matches this filter.");
        } else {
            returnList = results;
        }
        return returnList.toArray(new String[0]);
    }

    private void performActionOnCaches(long minSize, long maxSize, String minLastModifyDate, String maxLastModifyDate, String minExpiresDate, String maxExpiresDate, CacheAction action) {
        Date minExpires = this.parseDate(minExpiresDate);
        Date maxExpires = this.parseDate(maxExpiresDate);
        Date minLastModify = this.parseDate(minLastModifyDate);
        Date maxLastModify = this.parseDate(maxLastModifyDate);
        int points = this.countPoints(minSize, maxSize, minLastModify, maxLastModify, minExpires, maxExpires);
        for (Cache cache : this.caches) {
            for (CacheKey cacheKey : cache.keySet()) {
                int score = 0;
                CacheValue cacheValue = cache.get(cacheKey);
                if (cacheValue == null) continue;
                if (minSize >= 0L && cacheValue.size() >= (double)minSize) {
                    ++score;
                }
                if (maxSize >= 0L && cacheValue.size() <= (double)maxSize) {
                    ++score;
                }
                Date lastModifyDate = new Date(cacheKey.getLastModified());
                if (minLastModify != null && lastModifyDate.compareTo(minLastModify) >= 0) {
                    ++score;
                }
                if (maxLastModify != null && lastModifyDate.compareTo(maxLastModify) <= 0) {
                    ++score;
                }
                if ((minExpires != null || maxExpires != null) && cacheKey instanceof ExpiresCacheKey) {
                    ExpiresCacheKey expiresCacheKey = (ExpiresCacheKey)cacheKey;
                    Date expiresDate = new Date(expiresCacheKey.getExpirationTimestamp());
                    if (minExpires != null && expiresDate.compareTo(minExpires) >= 0) {
                        ++score;
                    }
                    if (maxExpires != null && expiresDate.compareTo(maxExpires) <= 0) {
                        ++score;
                    }
                }
                if (score != points) continue;
                action.performAction(cache, cacheKey);
            }
        }
    }

    private Date parseDate(String date) {
        long factor;
        if (StringUtils.isEmpty((String)date)) {
            return null;
        }
        if (!date.matches("^\\d+[smhd]$")) {
            throw new UnsupportedOperationException("Unsupported date format: " + date);
        }
        char unit = date.charAt(date.length() - 1);
        long multipler = Long.parseLong(date.substring(0, date.length() - 2));
        switch (unit) {
            case 's': {
                factor = 1000L;
                break;
            }
            case 'm': {
                factor = 60000L;
                break;
            }
            case 'h': {
                factor = 3600000L;
                break;
            }
            case 'd': {
                factor = 86400000L;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported unit: " + unit);
            }
        }
        return new Date(System.currentTimeMillis() - multipler * factor);
    }

    private int countPoints(long minSize, long maxSize, Date minLastModifyDate, Date maxLastModifiDate, Date minExpiresDate, Date maxExpiresDate) {
        int points = 0;
        if (minSize >= 0L) {
            ++points;
        }
        if (maxSize >= 0L) {
            ++points;
        }
        if (minLastModifyDate != null) {
            ++points;
        }
        if (maxLastModifiDate != null) {
            ++points;
        }
        if (minExpiresDate != null) {
            ++points;
        }
        if (maxExpiresDate != null) {
            ++points;
        }
        return points;
    }

    private static interface CacheAction {
        public void performAction(Cache var1, CacheKey var2);
    }
}

