/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.cocoon.sax.xpointer.ParseException;
import org.apache.cocoon.sax.xpointer.XPointer;
import org.apache.cocoon.sax.xpointer.XPointerContext;
import org.apache.cocoon.sax.xpointer.XPointerFrameworkParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XIncludeTransformer
extends AbstractSAXTransformer
implements SAXConsumer {
    private static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    private static final String XINCLUDE_INCLUDE = "include";
    private static final String XINCLUDE_FALLBACK = "fallback";
    private static final String XINCLUDE_HREF = "href";
    private static final String XINCLUDE_XPOINTER = "xpointer";
    private static final String XINCLUDE_PARSE = "parse";
    private static final String XINCLUDE_ENCODING = "encoding";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String XINCLUDE_ACCEPT = "accept";
    private static final String XINCLUDE_ACCEPT_LANGUAGE = "accept-language";
    private static final String XINCLUDE_PARSE_XML = "xml";
    private static final String XINCLUDE_PARSE_TEXT = "text";
    private static final String UNKNOWN_LOCATION = "unknow location";
    private static final String HTTP_ACCEPT = "Accept";
    private static final String HTTP_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String CHARSET = "charset=";
    private static final String BASE_URL = "baseUrl";
    private final Log logger = LogFactory.getLog(this.getClass());
    private int xIncludeElementLevel = 0;
    private int useFallbackLevel = 0;
    private int fallbackElementLevel;
    private Locator locator;
    private URL baseUrl;
    private final Map<String, String> namespaces = new HashMap<String, String>();

    public XIncludeTransformer() {
    }

    public XIncludeTransformer(URL baseUrl) {
        this.setBaseUrl(baseUrl);
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setBaseUrl((URL)configuration.get(BASE_URL));
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    protected void setSAXConsumer(SAXConsumer xmlConsumer) {
        super.setSAXConsumer(xmlConsumer);
        this.xIncludeElementLevel = 0;
        this.fallbackElementLevel = 0;
        this.useFallbackLevel = 0;
    }

    private boolean isEvaluatingContent() {
        return this.xIncludeElementLevel == 0 || this.fallbackElementLevel > 0 && this.fallbackElementLevel == this.useFallbackLevel;
    }

    private String getLocation() {
        if (this.locator == null) {
            return UNKNOWN_LOCATION;
        }
        return this.locator.getSystemId() + ":" + this.locator.getColumnNumber() + ":" + this.locator.getLineNumber();
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.xIncludeElementLevel == 0) {
            this.getSAXConsumer().startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.xIncludeElementLevel == 0) {
            this.getSAXConsumer().endDocument();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (XINCLUDE_NAMESPACE_URI.equals(uri)) {
            if (XINCLUDE_INCLUDE.equals(localName)) {
                if (this.isEvaluatingContent()) {
                    String href = atts.getValue("", XINCLUDE_HREF);
                    String parse = atts.getValue("", XINCLUDE_PARSE);
                    if (parse == null) {
                        parse = XINCLUDE_PARSE_XML;
                    }
                    String xpointer = atts.getValue("", XINCLUDE_XPOINTER);
                    String encoding = atts.getValue("", XINCLUDE_ENCODING);
                    String accept = atts.getValue("", XINCLUDE_ACCEPT);
                    String acceptLanguage = atts.getValue("", XINCLUDE_ACCEPT_LANGUAGE);
                    this.processXIncludeElement(href, parse, xpointer, encoding, accept, acceptLanguage);
                }
                ++this.xIncludeElementLevel;
                return;
            } else {
                if (!XINCLUDE_FALLBACK.equals(localName)) throw new SAXException("Unknown XInclude element " + localName + " at " + this.getLocation());
                ++this.fallbackElementLevel;
            }
            return;
        } else {
            if (!this.isEvaluatingContent()) return;
            this.getSAXConsumer().startElement(uri, localName, name, atts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processXIncludeElement(String href, String parse, String xpointer, String encoding, String accept, String acceptLanguage) throws SAXException {
        block30: {
            block33: {
                URLConnection urlConnection;
                block32: {
                    int fragmentIdentifierPos;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Processing XInclude element: href=" + href + ", parse=" + parse + ", xpointer=" + xpointer + ", encoding=" + encoding + ", accept=" + accept + ", acceptLanguage=" + acceptLanguage));
                    }
                    if ((fragmentIdentifierPos = href.indexOf(35)) != -1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Fragment identifer found in 'href' attribute: " + href + "\nFragment identifiers are forbidden by the XInclude specification. " + "They are still handled by XIncludeTransformer for backward " + "compatibility, but their use is deprecated and will be prohibited " + "in a future release. Use the 'xpointer' attribute instead."));
                        }
                        if (xpointer == null) {
                            xpointer = href.substring(fragmentIdentifierPos + 1);
                        }
                        href = href.substring(0, fragmentIdentifierPos);
                    }
                    if (!XIncludeTransformer.isNotEmpty(href)) {
                        throw new SAXException("XIncludeTransformer: encountered empty href (= href pointing to the current document).");
                    }
                    URL source = this.createSource(href);
                    urlConnection = null;
                    try {
                        urlConnection = source.openConnection();
                    }
                    catch (IOException ioe) {
                        ++this.useFallbackLevel;
                        this.logger.error((Object)("Error including document: " + source), (Throwable)ioe);
                    }
                    if (urlConnection == null) break block30;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Parse type=" + parse));
                    }
                    if (!XINCLUDE_PARSE_XML.equals(parse)) break block32;
                    if (urlConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                        if (XIncludeTransformer.isNotEmpty(accept)) {
                            httpURLConnection.setRequestProperty(HTTP_ACCEPT, accept);
                        }
                        if (XIncludeTransformer.isNotEmpty(acceptLanguage)) {
                            httpURLConnection.setRequestProperty(HTTP_ACCEPT_LANGUAGE, acceptLanguage);
                        }
                    }
                    if (xpointer != null && xpointer.length() > 0) {
                        try {
                            XPointerContext xPointerContext = new XPointerContext(xpointer, this);
                            for (Map.Entry<String, String> namespace : this.namespaces.entrySet()) {
                                xPointerContext.addPrefix(namespace.getKey(), namespace.getValue());
                            }
                            XPointer xPointer = XPointerFrameworkParser.parse(xpointer);
                            xPointer.setLog(this.logger);
                            xPointer.setUp(xPointerContext);
                            xPointer.setDocumentLocator(this.locator);
                            XMLUtils.toSax(urlConnection, (ContentHandler)xPointer);
                        }
                        catch (ParseException e) {
                            ++this.useFallbackLevel;
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error((Object)"Error parsing XPointer expression, will try to use fallback.", (Throwable)e);
                            }
                            break block30;
                        }
                        catch (IOException e) {
                            ++this.useFallbackLevel;
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error((Object)"Error processing an xInclude, will try to use fallback.", (Throwable)e);
                            }
                            break block30;
                        }
                    }
                    XMLUtils.toSax(urlConnection, (ContentHandler)this);
                    break block30;
                }
                if (!XINCLUDE_PARSE_TEXT.equals(parse)) break block33;
                if (xpointer != null) {
                    throw new SAXException("xpointer attribute must not be present when parse='text': " + this.getLocation());
                }
                String rawContentType = urlConnection.getContentType();
                if (encoding == null) {
                    int index = rawContentType != null ? rawContentType.indexOf(59) : -1;
                    String charset = null;
                    if (index != -1) {
                        charset = rawContentType.substring(index + 1).trim();
                        if (charset.startsWith(CHARSET)) {
                            if ((charset = charset.substring(CHARSET.length()).trim()).charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"' || charset.charAt(0) == '\'' && charset.charAt(charset.length() - 1) == '\'') {
                                encoding = charset.substring(1, charset.length() - 1);
                            }
                        } else {
                            encoding = DEFAULT_CHARSET;
                        }
                    } else {
                        encoding = DEFAULT_CHARSET;
                    }
                }
                InputStream is = null;
                InputStreamReader isr = null;
                BufferedReader reader = null;
                try {
                    int read;
                    is = urlConnection.getInputStream();
                    isr = new InputStreamReader(is, encoding);
                    reader = new BufferedReader(isr);
                    char[] ary = new char[4096];
                    while ((read = reader.read(ary)) != -1) {
                        this.getSAXConsumer().characters(ary, 0, read);
                    }
                }
                catch (IOException e) {
                    block31: {
                        try {
                            ++this.useFallbackLevel;
                            if (!this.logger.isErrorEnabled()) break block31;
                            this.logger.error((Object)"Error including text: ", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            XIncludeTransformer.closeQuietly(reader);
                            XIncludeTransformer.closeQuietly(isr);
                            XIncludeTransformer.closeQuietly(is);
                            throw throwable;
                        }
                    }
                    XIncludeTransformer.closeQuietly(reader);
                    XIncludeTransformer.closeQuietly(isr);
                    XIncludeTransformer.closeQuietly(is);
                    break block30;
                }
                XIncludeTransformer.closeQuietly(reader);
                XIncludeTransformer.closeQuietly(isr);
                XIncludeTransformer.closeQuietly(is);
                break block30;
            }
            throw new SAXException("Found 'parse' attribute with unknown value " + parse + " at " + this.getLocation());
        }
    }

    private URL createSource(String sourceAtt) {
        try {
            URL source = null;
            source = sourceAtt.contains(":") ? new URL(sourceAtt) : new URL(this.baseUrl, sourceAtt);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including source: " + source));
            }
            return source;
        }
        catch (MalformedURLException e) {
            String message = "Can't parse URL " + sourceAtt;
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)message, (Throwable)e);
            }
            throw new ProcessingException(message, (Throwable)e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (XINCLUDE_NAMESPACE_URI.equals(uri)) {
            if (XINCLUDE_INCLUDE.equals(localName)) {
                --this.xIncludeElementLevel;
                if (this.useFallbackLevel > this.xIncludeElementLevel) {
                    this.useFallbackLevel = this.xIncludeElementLevel;
                }
            } else if (XINCLUDE_FALLBACK.equals(localName)) {
                --this.fallbackElementLevel;
            }
        } else if (this.isEvaluatingContent()) {
            this.getSAXConsumer().endElement(uri, localName, name);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.isEvaluatingContent()) {
            if (!uri.equals(XINCLUDE_NAMESPACE_URI)) {
                this.getSAXConsumer().startPrefixMapping(prefix, uri);
            }
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().endPrefixMapping(prefix);
            this.namespaces.remove(prefix);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().startCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().endEntity(name);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setDocumentLocator called " + locator.getSystemId()));
        }
        this.locator = locator;
        this.getSAXConsumer().setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getSAXConsumer().skippedEntity(name);
        }
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    private static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

