/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.net.URL;
import java.util.Map;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.component.SchemaErrorHandler;
import org.apache.cocoon.sax.util.SAXConsumerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaProcessorTransformer
extends AbstractSAXTransformer {
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final String SOURCE = "source";
    private final Log logger = LogFactory.getLog(this.getClass());
    private Schema schema;
    private URL source;

    public SchemaProcessorTransformer() {
    }

    public SchemaProcessorTransformer(URL source) {
        this.init(source);
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.init((URL)configuration.get(SOURCE));
    }

    @Override
    public String toString() {
        return StringRepresentation.buildString((Object)this, (String[])new String[]{"src=" + this.source});
    }

    @Override
    protected void setSAXConsumer(SAXConsumer xmlConsumer) {
        ValidatorHandler validatorHandler = this.schema.newValidatorHandler();
        validatorHandler.setErrorHandler(new SchemaErrorHandler(this.logger, this.source.toExternalForm()));
        validatorHandler.setContentHandler(xmlConsumer);
        SAXConsumerAdapter saxConsumerAdapter = new SAXConsumerAdapter();
        saxConsumerAdapter.setContentHandler(validatorHandler);
        super.setSAXConsumer(saxConsumerAdapter);
    }

    private void init(URL source) {
        if (source == null) {
            throw new IllegalArgumentException("The parameter 'source' mustn't be null.");
        }
        try {
            this.schema = SCHEMA_FACTORY.newSchema(source);
        }
        catch (SAXException e) {
            throw new SetupException("Could not initialize xschema source", (Throwable)e);
        }
        this.source = source;
    }
}

