/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.jaxrs.response;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cocoon.callstack.environment.CallFrameHelper;
import org.apache.cocoon.servlet.controller.ControllerContextHelper;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLResponseBuilder
extends Response.ResponseBuilder {
    public static Response.ResponseBuilder newInstance(String url) {
        return URLResponseBuilder.newInstance(url, (Map<String, Object>)Collections.EMPTY_MAP);
    }

    public static Response.ResponseBuilder newInstance(String url, Map<String, Object> data) {
        try {
            return URLResponseBuilder.newInstance(new URL(url), data);
        }
        catch (MalformedURLException e) {
            throw new WebApplicationException(500);
        }
    }

    public static Response.ResponseBuilder newInstance(URL url) {
        return URLResponseBuilder.newInstance(url, (Map<String, Object>)Collections.EMPTY_MAP);
    }

    public static Response.ResponseBuilder newInstance(URL url, Map<String, Object> data) {
        Response.ResponseBuilder builder = Response.ResponseBuilder.newInstance();
        URLConnection urlConnection = null;
        try {
            urlConnection = url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpUrlConnection = (HttpURLConnection)urlConnection;
                HttpServletRequest request = CallFrameHelper.getRequest();
                ControllerContextHelper.storeContext(data, (HttpServletRequest)request);
                String contentType = httpUrlConnection.getContentType();
                if (contentType != null && !"".equals(contentType) && !"content/unknown".equals(contentType)) {
                    builder.type(contentType);
                }
                Map<String, List<String>> headerFields = httpUrlConnection.getHeaderFields();
                for (Map.Entry<String, List<String>> eachHeader : headerFields.entrySet()) {
                    List<String> headerValueList = eachHeader.getValue();
                    String value = null;
                    if (!headerValueList.isEmpty()) {
                        value = headerValueList.get(0);
                    }
                    builder.header(eachHeader.getKey(), (Object)(value == null ? "" : value));
                }
                int statusCode = httpUrlConnection.getResponseCode();
                builder.status(statusCode);
                long lastModified = urlConnection.getLastModified();
                if (lastModified >= 0L) {
                    builder.lastModified(new Date(lastModified));
                }
                builder.entity((Object)IOUtils.toString((InputStream)httpUrlConnection.getInputStream()));
                return builder;
            }
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, 500);
        }
        throw new WebApplicationException(500);
    }
}

