/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.rest.controller.annotation.BaseURL;
import org.apache.cocoon.rest.controller.annotation.Inject;
import org.apache.cocoon.rest.controller.annotation.RequestHeader;
import org.apache.cocoon.rest.controller.annotation.RequestParameter;
import org.apache.cocoon.rest.controller.annotation.SitemapParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCollector {
    private static final Log LOG = LogFactory.getLog(AnnotationCollector.class);
    private Map<Class<?>, Map<Class<? extends Annotation>, List<Field>>> annotatedFieldsCache = new HashMap();
    private Set<Class<? extends Annotation>> relevantAnnotations = new HashSet<Class<? extends Annotation>>();

    public AnnotationCollector() {
        this.relevantAnnotations.add(BaseURL.class);
        this.relevantAnnotations.add(Inject.class);
        this.relevantAnnotations.add(RequestHeader.class);
        this.relevantAnnotations.add(RequestParameter.class);
        this.relevantAnnotations.add(SitemapParameter.class);
    }

    public synchronized Map<Class<? extends Annotation>, List<Field>> getAnnotatedFields(Class<?> type) {
        Map<Class<? extends Annotation>, List<Field>> result = this.annotatedFieldsCache.get(type);
        if (result == null) {
            result = this.collectAnnotatedFields(type);
            this.annotatedFieldsCache.put(type, result);
        }
        return result;
    }

    private Map<Class<? extends Annotation>, List<Field>> collectAnnotatedFields(Class<?> type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Collecting annotations of class " + type + "."));
        }
        HashMap<Class<? extends Annotation>, List<Field>> result = new HashMap<Class<? extends Annotation>, List<Field>>();
        for (Field field : this.getFields(type)) {
            for (Annotation availableAnnotation : field.getAnnotations()) {
                Class<? extends Annotation> annotationType = availableAnnotation.annotationType();
                if (!this.relevantAnnotations.contains(annotationType)) continue;
                LinkedList<Field> annotatedFields = (LinkedList<Field>)result.get(annotationType);
                if (annotatedFields == null) {
                    annotatedFields = new LinkedList<Field>();
                    result.put(annotationType, annotatedFields);
                }
                annotatedFields.add(field);
            }
        }
        return result;
    }

    private List<Field> getFields(Class<?> type) {
        LinkedList<Field> result = new LinkedList<Field>();
        Class<?> currentClass = type;
        do {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(declaredField.getModifiers())) continue;
                result.add(declaredField);
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return result;
    }
}

