/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.RestResponseMetaData;
import org.apache.cocoon.servlet.controller.ControllerContextHelper;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLResponse
implements RestResponse {
    private URL url;
    private Map<String, Object> data;

    public URLResponse(URL url) {
        this.url = url;
        this.data = Collections.emptyMap();
    }

    public URLResponse(String url) throws MalformedURLException {
        this.url = new URL(new URL("servlet:"), url);
        this.data = Collections.emptyMap();
    }

    public URLResponse(URL url, Map<String, Object> data) {
        this.url = url;
        this.data = data;
    }

    public URLResponse(String url, Map<String, Object> data) throws MalformedURLException {
        this.url = new URL(new URL("servlet:"), url);
        this.data = data;
    }

    public Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponseMetaData execute(OutputStream outputStream, Map<String, Object> inputParameters) throws Exception {
        RestResponseMetaData restResponseMetaData;
        URLConnection servletConnection = null;
        try {
            ControllerContextHelper.storeContext(this.data, inputParameters);
            servletConnection = this.url.openConnection();
            IOUtils.copy((InputStream)servletConnection.getInputStream(), (OutputStream)outputStream);
            RestResponseMetaData restResponseMetaData2 = new RestResponseMetaData();
            if (servletConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)servletConnection;
                restResponseMetaData2.setStatusCode(httpURLConnection.getResponseCode());
            }
            restResponseMetaData2.setContentType(servletConnection.getContentType());
            restResponseMetaData = restResponseMetaData2;
        }
        catch (Throwable throwable) {
            URLConnectionUtils.closeQuietly(servletConnection);
            throw throwable;
        }
        URLConnectionUtils.closeQuietly((URLConnection)servletConnection);
        return restResponseMetaData;
    }
}

