/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.controller.Controller;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.rest.controller.MethodDelegator;
import org.apache.cocoon.rest.controller.annotation.BaseURL;
import org.apache.cocoon.rest.controller.annotation.Inject;
import org.apache.cocoon.rest.controller.annotation.RequestHeader;
import org.apache.cocoon.rest.controller.annotation.RequestParameter;
import org.apache.cocoon.rest.controller.annotation.SitemapParameter;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.RestResponseMetaData;
import org.apache.cocoon.rest.controller.util.AnnotationCollector;
import org.apache.cocoon.servlet.collector.ResponseHeaderCollector;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.apache.cocoon.servlet.util.SettingsHelper;
import org.apache.cocoon.sitemap.util.ExceptionHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringRESTController
implements Controller,
ApplicationContextAware {
    private AnnotationCollector annotationCollector;
    private ApplicationContext applicationContext;
    private MethodDelegator methodDelegator;

    public void invoke(OutputStream outputStream, String controllerName, Map<String, Object> inputParameters, Map<String, ? extends Object> configuration) {
        if (!this.applicationContext.isPrototype(controllerName)) {
            throw new ProcessingException("A REST controller bean MUST run within the 'prototype' scope.");
        }
        try {
            Object controller = this.getController(controllerName, inputParameters, configuration);
            HttpServletRequest request = HttpContextHelper.getRequest(inputParameters);
            RestResponse restResponse = this.methodDelegator.delegate(request, controller);
            RestResponseMetaData restResponseMetaData = restResponse.execute(outputStream, inputParameters);
            ResponseHeaderCollector.setStatusCode((int)restResponseMetaData.getStatusCode());
            ResponseHeaderCollector.setMimeType((String)restResponseMetaData.getContentType());
        }
        catch (Exception e) {
            throw ExceptionHandler.getInvocationException((Throwable)e);
        }
    }

    public void setAnnotationCollector(AnnotationCollector annotationCollector) {
        this.annotationCollector = annotationCollector;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMethodDelegator(MethodDelegator methodDelegator) {
        this.methodDelegator = methodDelegator;
    }

    private Object getController(String controllerName, Map<String, Object> inputParameters, Map<String, ? extends Object> configuration) throws Exception {
        Object controller = this.applicationContext.getBean(controllerName);
        Object unpackedController = SpringRESTController.unpackProxy(controller);
        Map<Class<? extends Annotation>, List<Field>> annotatedFields = this.annotationCollector.getAnnotatedFields(unpackedController.getClass());
        SpringRESTController.populateInjectFields(inputParameters, unpackedController, annotatedFields);
        SpringRESTController.populateRequestFields(inputParameters, unpackedController, annotatedFields);
        SpringRESTController.populateRequestHeaderFields(inputParameters, unpackedController, annotatedFields);
        SpringRESTController.populateSitemapParameters(configuration, unpackedController, annotatedFields);
        this.populateBaseURL(configuration, unpackedController, annotatedFields);
        return controller;
    }

    private void populateBaseURL(Map<String, ? extends Object> configuration, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException, Exception {
        List<Field> baseURLFields = annotatedFields.get(BaseURL.class);
        if (baseURLFields == null || baseURLFields.isEmpty()) {
            return;
        }
        for (Field field : baseURLFields) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType == URL.class) {
                field.set(controller, configuration.get("baseUrl"));
                continue;
            }
            throw new Exception("The annotation " + BaseURL.class.getName() + " can only be set on fields of type " + URL.class.getName() + "." + " " + "(field=" + field.getName() + ", type=" + fieldType.getName() + ")");
        }
    }

    public static <T> T unpackProxy(T proxy) throws Exception {
        if (proxy instanceof Advised) {
            Advised advised = (Advised)proxy;
            return (T)advised.getTargetSource().getTarget();
        }
        return proxy;
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void populateInjectFields(Map<String, ? extends Object> parameters, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException, IOException, Exception {
        List<Field> injectFields = annotatedFields.get(Inject.class);
        if (injectFields == null || injectFields.isEmpty()) {
            return;
        }
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        HttpServletResponse response = HttpContextHelper.getResponse(parameters);
        for (Field field : injectFields) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType == HttpServletRequest.class) {
                field.set(controller, request);
                continue;
            }
            if (fieldType == HttpServletResponse.class) {
                field.set(controller, response);
                continue;
            }
            if (fieldType == Log.class) {
                field.set(controller, LogFactory.getLog(controller.getClass()));
                continue;
            }
            if (fieldType == ServletInputStream.class || fieldType == InputStream.class) {
                field.set(controller, request.getInputStream());
                continue;
            }
            if (fieldType == ServletOutputStream.class || fieldType == OutputStream.class) {
                field.set(controller, response.getOutputStream());
                continue;
            }
            if (fieldType == ServletContext.class) {
                ServletContext servletContext = HttpContextHelper.getServletContext(parameters);
                field.set(controller, servletContext);
                continue;
            }
            if (fieldType == Settings.class) {
                Settings settings = SettingsHelper.getSettings(parameters);
                field.set(controller, settings);
                continue;
            }
            throw new Exception("The annotation " + Inject.class.getName() + " doesn't support the injection of type " + fieldType.getName() + "." + " " + "(field=" + field.getName() + ", type=" + fieldType.getName() + ")");
        }
    }

    private static void populateRequestFields(Map<String, ? extends Object> parameters, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException, Exception {
        List<Field> requestFields = annotatedFields.get(RequestParameter.class);
        if (requestFields == null || requestFields.isEmpty()) {
            return;
        }
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        for (Field field : requestFields) {
            String parameter;
            Class<?> fieldType;
            field.setAccessible(true);
            String requestParameterName = field.getAnnotation(RequestParameter.class).value();
            if (SpringRESTController.isBlank(requestParameterName)) {
                requestParameterName = field.getName();
            }
            if ((fieldType = field.getType()) == String.class) {
                parameter = request.getParameter(requestParameterName);
                if (parameter == null) continue;
                field.set(controller, parameter);
                continue;
            }
            if (fieldType == Integer.TYPE) {
                parameter = request.getParameter(requestParameterName);
                if (parameter == null) continue;
                field.set(controller, Integer.parseInt(parameter));
                continue;
            }
            if (fieldType == Boolean.TYPE) {
                parameter = request.getParameter(requestParameterName);
                if (parameter == null) continue;
                field.set(controller, Boolean.parseBoolean(parameter));
                continue;
            }
            if (fieldType == String[].class) {
                String[] parameterValues = request.getParameterValues(requestParameterName);
                if (parameterValues == null) continue;
                field.set(controller, parameterValues);
                continue;
            }
            throw new Exception("The annotation " + RequestParameter.class.getName() + " can only be set on fields of type " + String.class.getName() + ", " + String[].class.getName() + ", " + Integer.TYPE.getName() + " or " + Boolean.TYPE.getName() + ". (field=" + field.getName() + ", type=" + fieldType.getName() + ")");
        }
    }

    private static void populateRequestHeaderFields(Map<String, ? extends Object> parameters, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException, Exception {
        List<Field> requestHeaderFields = annotatedFields.get(RequestHeader.class);
        if (requestHeaderFields == null || requestHeaderFields.isEmpty()) {
            return;
        }
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        for (Field field : requestHeaderFields) {
            Class<?> fieldType;
            field.setAccessible(true);
            String name = field.getAnnotation(RequestHeader.class).value();
            if (SpringRESTController.isBlank(name)) {
                name = field.getName();
            }
            if ((fieldType = field.getType()) == String.class) {
                String header = request.getHeader(name);
                if (header == null) continue;
                field.set(controller, header);
                continue;
            }
            throw new Exception("The annotation " + RequestHeader.class.getName() + " can only be set on fields of type " + String.class.getName() + "." + " " + "(field=" + field.getName() + ", type=" + fieldType.getName() + ")");
        }
    }

    private static void populateSitemapParameters(Map<String, ? extends Object> configuration, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException, Exception {
        List<Field> sitemapParameterFields = annotatedFields.get(SitemapParameter.class);
        if (sitemapParameterFields == null || sitemapParameterFields.isEmpty()) {
            return;
        }
        for (Field field : sitemapParameterFields) {
            Class<?> fieldType;
            field.setAccessible(true);
            String name = field.getAnnotation(SitemapParameter.class).value();
            if (SpringRESTController.isBlank(name)) {
                name = field.getName();
            }
            if ((fieldType = field.getType()) == String.class) {
                field.set(controller, configuration.get(name));
                continue;
            }
            throw new Exception("The annotation " + SitemapParameter.class.getName() + " can only be set on fields of type " + String.class.getName() + "." + " " + "(field=" + field.getName() + ", type=" + fieldType.getName() + ")");
        }
    }
}

