/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.rest.controller.method.Delete;
import org.apache.cocoon.rest.controller.method.Get;
import org.apache.cocoon.rest.controller.method.Head;
import org.apache.cocoon.rest.controller.method.Options;
import org.apache.cocoon.rest.controller.method.Post;
import org.apache.cocoon.rest.controller.method.Put;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.Status;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodDelegator {
    private static Map<String, MethodDelegate> delegates = new HashMap<String, MethodDelegate>();
    private final Log logger = LogFactory.getLog(this.getClass());

    public RestResponse delegate(HttpServletRequest request, Object controller) throws Exception {
        MethodDelegate methodDelegate;
        if (request != null && request.getMethod() != null && (methodDelegate = delegates.get(this.getMethod(request))) != null) {
            return methodDelegate.execute(controller);
        }
        return new Status(405);
    }

    private String getMethod(HttpServletRequest request) {
        String alternativeMethod = request.getParameter("_method");
        if (alternativeMethod != null) {
            alternativeMethod = alternativeMethod.toUpperCase();
            if (delegates.keySet().contains(alternativeMethod)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using alternative request method '" + alternativeMethod + "' as provided by the request parameter '_method'"));
                }
                return alternativeMethod;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("The request parameter '_request' refers to an unsupported request method: _method='" + alternativeMethod + "'"));
            }
        }
        return request.getMethod().toUpperCase();
    }

    static {
        delegates.put("DELETE", new DeleteDelegate());
        delegates.put("GET", new GetDelegate());
        delegates.put("HEAD", new HeadDelegate());
        delegates.put("OPTIONS", new OptionsDelegate());
        delegates.put("POST", new PostDelegate());
        delegates.put("PUT", new PutDelegate());
    }

    private static class PutDelegate
    extends MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            if (controller instanceof Put) {
                Put put = (Put)controller;
                return put.doPut();
            }
            return super.execute(controller);
        }
    }

    private static class PostDelegate
    extends MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            if (controller instanceof Post) {
                Post post = (Post)controller;
                return post.doPost();
            }
            return super.execute(controller);
        }
    }

    private static class OptionsDelegate
    extends MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            if (controller instanceof Options) {
                Options options = (Options)controller;
                return options.doOptions();
            }
            return super.execute(controller);
        }
    }

    private static abstract class MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            return new Status(405);
        }
    }

    private static class HeadDelegate
    extends MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            if (controller instanceof Head) {
                Head head = (Head)controller;
                return head.doHead();
            }
            return new GetDelegate().execute(controller);
        }
    }

    private static class GetDelegate
    extends MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            if (controller instanceof Get) {
                Get get = (Get)controller;
                return get.doGet();
            }
            return super.execute(controller);
        }
    }

    private static class DeleteDelegate
    extends MethodDelegate {
        public RestResponse execute(Object controller) throws Exception {
            if (controller instanceof Delete) {
                Delete delete = (Delete)controller;
                return delete.doDelete();
            }
            return super.execute(controller);
        }
    }
}

