/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stringtemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CompoundCacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.cocoon.pipeline.caching.TimestampCacheKey;
import org.apache.cocoon.pipeline.component.AbstractPipelineComponent;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.servlet.controller.ControllerContextHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTemplateReader
extends AbstractPipelineComponent
implements CachingPipelineComponent,
Starter,
Finisher {
    private String mimeType;
    private OutputStream outputStream;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private URL source;

    public StringTemplateReader() {
        this(null);
    }

    public StringTemplateReader(URL source) {
        this.setSource(source);
    }

    public CacheKey constructCacheKey() {
        if (this.source == null) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " has no source.");
        }
        CompoundCacheKey cacheKey = new CompoundCacheKey();
        try {
            cacheKey.addCacheKey((CacheKey)new TimestampCacheKey(this.source, this.source.openConnection().getLastModified()));
            cacheKey.addCacheKey((CacheKey)new ParameterCacheKey("contextParameters", this.parameters));
        }
        catch (IOException e) {
            throw new SetupException("Could not create cache key.", (Throwable)e);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.source == null) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " has no source.");
        }
        try {
            InputStream inputStream = this.source.openStream();
            try {
                StringTemplate stringTemplate = new StringTemplate(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"));
                stringTemplate.registerRenderer(String.class, new AttributeRenderer(){

                    public String toString(Object object) {
                        return StringEscapeUtils.escapeXml((String)object.toString());
                    }
                });
                Map controllerContext = ControllerContextHelper.getContext(this.parameters);
                for (Map.Entry eachEntry : controllerContext.entrySet()) {
                    stringTemplate.setAttribute((String)eachEntry.getKey(), eachEntry.getValue());
                }
                OutputStreamWriter writer = new OutputStreamWriter(this.outputStream);
                writer.write(stringTemplate.toString());
                writer.flush();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to produce result.", (Throwable)e);
        }
    }

    public String getContentType() {
        return this.mimeType;
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setSource((URL)configuration.get("source"));
        this.setMimeType((String)configuration.get("mime-type"));
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setSource(URL source) {
        this.source = source;
    }

    public void setup(Map<String, Object> parameters) {
        super.setup(parameters);
        this.parameters = parameters;
    }
}

