/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stringtemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.cocoon.pipeline.PipelineException;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CompoundCacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.cocoon.pipeline.caching.TimestampCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.sax.AbstractSAXProducer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTemplateGenerator
extends AbstractSAXProducer
implements Starter,
CachingPipelineComponent {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private URL source;
    protected Map<String, Object> parameters = new HashMap<String, Object>();

    public StringTemplateGenerator() {
    }

    public StringTemplateGenerator(URL source) {
        this.setSource(source);
    }

    public CacheKey constructCacheKey() {
        CompoundCacheKey cacheKey = new CompoundCacheKey();
        try {
            cacheKey.addCacheKey((CacheKey)new TimestampCacheKey(this.source, this.source.openConnection().getLastModified()));
            cacheKey.addCacheKey((CacheKey)new ParameterCacheKey("contextParameters", this.parameters));
        }
        catch (IOException e) {
            throw new SetupException((Throwable)e);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.source == null) {
            throw new IllegalArgumentException("StringTemplateGenerator has no source.");
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using template: " + this.source.toURI().toASCIIString()));
            }
            InputStream inputStream = this.source.openStream();
            try {
                StringTemplate stringTemplate = new StringTemplate(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"));
                stringTemplate.registerRenderer(String.class, new AttributeRenderer(){

                    public String toString(Object object) {
                        return StringEscapeUtils.escapeXml((String)object.toString());
                    }
                });
                this.addTemplateAttributes(stringTemplate);
                XMLUtils.createXMLReader((ContentHandler)this.getSAXConsumer()).parse(new InputSource(new StringReader(stringTemplate.toString())));
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (PipelineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Can't parse url connection " + this.source, (Throwable)e);
        }
    }

    protected void addTemplateAttributes(StringTemplate stringTemplate) {
        for (Map.Entry<String, Object> eachEntry : this.parameters.entrySet()) {
            stringTemplate.setAttribute(eachEntry.getKey().replace(".", "_"), eachEntry.getValue());
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Passing pipeline parameter as attribute: key=" + eachEntry.getKey() + ", value=" + eachEntry.getValue()));
        }
    }

    public void setup(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setSource(URL source) {
        this.source = source;
    }
}

