/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.spring;

import java.util.Map;
import javax.servlet.Servlet;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.profiling.aspects.InvocationDispatcher;
import org.apache.cocoon.profiling.data.ProfilingDataManager;
import org.apache.cocoon.profiling.data.ProfilingIdGenerator;
import org.apache.cocoon.profiling.profiler.Profiler;
import org.apache.cocoon.sitemap.node.SitemapNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticProfilerInstaller {
    private final Log logger = LogFactory.getLog(this.getClass());
    private InvocationDispatcher pipelineComponentInvocationDispatcher;
    private InvocationDispatcher pipelineInvocationDispatcher;
    private Map<String, Profiler<?>> profilers;
    private ProfilingDataManager profilingDataManager;
    private ProfilingIdGenerator profilingIdGenerator;
    private InvocationDispatcher servletInvocationDispatcher;
    private InvocationDispatcher sitemapNodeInvocationDispatcher;

    public void installProfilers() {
        for (Profiler<?> p : this.profilers.values()) {
            this.install(p);
        }
    }

    public void setPipelineComponentInvocationDispatcher(InvocationDispatcher pipelineComponentInvocationDispatcher) {
        this.pipelineComponentInvocationDispatcher = pipelineComponentInvocationDispatcher;
    }

    public void setPipelineInvocationDispatcher(InvocationDispatcher pipelineInvocationDispatcher) {
        this.pipelineInvocationDispatcher = pipelineInvocationDispatcher;
    }

    public void setProfilers(Map<String, Profiler<?>> profilers) {
        this.profilers = profilers;
    }

    public void setProfilingDataManager(ProfilingDataManager profilingDataManager) {
        this.profilingDataManager = profilingDataManager;
    }

    public void setProfilingIdGenerator(ProfilingIdGenerator profilingIdGenerator) {
        this.profilingIdGenerator = profilingIdGenerator;
    }

    public void setServletInvocationDispatcher(InvocationDispatcher servletInvocationDispatcher) {
        this.servletInvocationDispatcher = servletInvocationDispatcher;
    }

    public void setSitemapNodeInvocationDispatcher(InvocationDispatcher sitemapNodeInvocationDispatcher) {
        this.sitemapNodeInvocationDispatcher = sitemapNodeInvocationDispatcher;
    }

    private void install(Profiler<?> profiler) {
        profiler.setProfilingDataManager(this.profilingDataManager);
        profiler.setProfilingIdGenerator(this.profilingIdGenerator);
        if (Servlet.class.isAssignableFrom(profiler.getTargetClass())) {
            this.installServletProfiler(profiler);
        }
        if (SitemapNode.class.isAssignableFrom(profiler.getTargetClass())) {
            this.installSitemapNodeProfiler(profiler);
        }
        if (PipelineComponent.class.isAssignableFrom(profiler.getTargetClass())) {
            this.installPipelineComponentProfiler(profiler);
        }
        if (Pipeline.class.isAssignableFrom(profiler.getTargetClass())) {
            this.installPipelineProfiler(profiler);
        }
    }

    private void installPipelineComponentProfiler(Profiler<?> profiler) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing PipelineComponent Profiler: " + profiler));
        }
        this.pipelineComponentInvocationDispatcher.installProfiler(profiler);
    }

    private void installPipelineProfiler(Profiler<?> profiler) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing Pipeline Profiler: " + profiler));
        }
        this.pipelineInvocationDispatcher.installProfiler(profiler);
    }

    private void installServletProfiler(Profiler<?> profiler) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing Servlet Profiler: " + profiler));
        }
        this.servletInvocationDispatcher.installProfiler(profiler);
    }

    private void installSitemapNodeProfiler(Profiler<?> profiler) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing SitemapNode Profiler: " + profiler));
        }
        this.sitemapNodeInvocationDispatcher.installProfiler(profiler);
    }
}

