/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.profiler;

import java.lang.reflect.Field;
import org.apache.cocoon.profiling.ProfileMethod;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.profiler.Profiler;
import org.apache.cocoon.sitemap.node.TransformNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformNodeProfiler
extends Profiler<TransformNode> {
    public TransformNodeProfiler() {
        super(TransformNode.class);
    }

    @ProfileMethod(name="invoke")
    public void beforeInvoke(ProfilingData data, TransformNode component, Object[] args) {
        try {
            Field srcField = TransformNode.class.getDeclaredField("src");
            srcField.setAccessible(true);
            String src = (String)srcField.get(component);
            if (src != null) {
                data.addData("src", src);
            }
            Field typeField = TransformNode.class.getDeclaredField("type");
            typeField.setAccessible(true);
            String type = (String)typeField.get(component);
            if (type != null) {
                data.addData("type", type);
                String simpleName = component.getClass().getSimpleName();
                data.setDisplayName(String.format("%s (%s=%s)", simpleName, "type", type));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading private fields from TransformNode", e);
        }
    }
}

