/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.profiler;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.profiling.ProfileMethod;
import org.apache.cocoon.profiling.ProfileMethodType;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.profiler.Profiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletProfiler
extends Profiler<Servlet> {
    private static final String PROFILING_CONTROLLER_PATH = "cocoon-profiling/";
    private static final String PROFILING_ID_HEADER = "X-Cocoon-Profiling-ID";
    private static final String PROFILING_URL_HEADER = "X-Cocoon-Profiling-URL";
    private String mountPath;

    public ServletProfiler() {
        this((Class<? extends Servlet>)Servlet.class);
    }

    protected ServletProfiler(Class<? extends Servlet> clazz) {
        super(clazz);
        this.setMountPath("/");
    }

    @ProfileMethod(name="service", type=ProfileMethodType.BEFORE_INVOCATION)
    public final void beforeService(ProfilingData data, Servlet component, Object[] args) {
        HttpServletRequest request;
        if (data.isRoot()) {
            request = (HttpServletRequest)args[0];
            HttpServletResponse response = (HttpServletResponse)args[1];
            String profilingId = data.getProfilingId();
            String requestUrl = request.getRequestURL().toString();
            response.addHeader(PROFILING_ID_HEADER, profilingId);
            response.addHeader(PROFILING_URL_HEADER, this.createRelativeUrl(requestUrl, profilingId));
        }
        request = (HttpServletRequest)args[0];
        String requestURI = request.getRequestURI();
        String className = component.getClass().getSimpleName();
        data.setDisplayName(String.format("%s (request=%s)", className, requestURI));
    }

    public String createRelativeUrl(String inputUrl, String profilingId) {
        String mountPath = this.getMountPath();
        int questionMarkIndex = inputUrl.indexOf(63);
        if (questionMarkIndex != -1) {
            inputUrl = inputUrl.substring(0, questionMarkIndex);
        }
        int inputUrlSlashes = this.countOccurenceOfCharacter('/', inputUrl) - 2;
        int mountPathSlashes = this.countOccurenceOfCharacter('/', mountPath);
        StringBuilder sb = new StringBuilder();
        for (int i = mountPathSlashes; i < inputUrlSlashes; ++i) {
            sb.append("../");
        }
        sb.append(PROFILING_CONTROLLER_PATH);
        sb.append(profilingId);
        return sb.toString();
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    private int countOccurenceOfCharacter(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }
}

