/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.profiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.callstack.CallStack;
import org.apache.cocoon.profiling.ProfileMethod;
import org.apache.cocoon.profiling.ProfileMethodType;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.data.ProfilingDataManager;
import org.apache.cocoon.profiling.data.ProfilingIdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Profiler<T> {
    private static ThreadLocal<Integer> depth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ProfilingDataManager dataManager;
    private Map<ProfileMethodType, List<Method>> defaultProfileMethods;
    private ProfilingIdGenerator idGenerator;
    private Map<ProfileMethodType, Map<String, List<Method>>> profileMethods;
    private Class<? extends T> targetClass;

    public Profiler(Class<? extends T> targetClass) {
        this.targetClass = targetClass;
        this.profileMethods = new HashMap<ProfileMethodType, Map<String, List<Method>>>();
        this.defaultProfileMethods = new HashMap<ProfileMethodType, List<Method>>();
        for (ProfileMethodType type : ProfileMethodType.values()) {
            this.profileMethods.put(type, new HashMap());
        }
        this.findProfilingMethods();
    }

    public final void after(ProfilingData data, String methodName, Object returnValue) {
        data.setInvocationEndTime(System.nanoTime());
        this.invokeSpecificMethods(ProfileMethodType.AFTER_INVOCATION, methodName, data, returnValue);
        this.invokeDefaultMethods(ProfileMethodType.AFTER_INVOCATION, data, returnValue);
        data.setReturnValue(returnValue);
        this.postProcessInvocation(data);
    }

    public final void before(ProfilingData data, Object target, String methodName, Object[] args) {
        String id = this.idGenerator.getCurrent();
        if (id == null) {
            data.setRoot(true);
            id = this.idGenerator.create();
        }
        data.setProfilingId(id);
        data.setInvocationDepth(depth.get());
        depth.set(depth.get() + 1);
        data.setTarget(target);
        data.setProfiler(this.getClass().getName());
        data.setMethod(methodName);
        data.setArguments(args);
        data.setCallFrameId(System.identityHashCode(CallStack.getCurrentFrame()));
        this.invokeSpecificMethods(ProfileMethodType.BEFORE_INVOCATION, methodName, data, target, args);
        this.invokeDefaultMethods(ProfileMethodType.BEFORE_INVOCATION, data, target, args);
        data.setInvocationStartTime(System.nanoTime());
    }

    public final void exception(ProfilingData data, String methodName, Exception exception) {
        data.setInvocationEndTime(System.nanoTime());
        data.setException(exception);
        this.invokeSpecificMethods(ProfileMethodType.ON_EXCEPTION, methodName, data, exception);
        this.invokeDefaultMethods(ProfileMethodType.ON_EXCEPTION, data, exception);
        this.postProcessInvocation(data);
    }

    public final Class<? extends T> getTargetClass() {
        return this.targetClass;
    }

    public void setProfilingDataManager(ProfilingDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public void setProfilingIdGenerator(ProfilingIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    private void checkProfileMethodSignature(Method method, String name, ProfileMethodType type) {
        Class<?>[] pt = method.getParameterTypes();
        switch (type) {
            case BEFORE_INVOCATION: {
                if (pt.length == 3 && pt[0] == ProfilingData.class && pt[1].isAssignableFrom(this.targetClass) && pt[2] == Object[].class) break;
                throw new RuntimeException("Signature of method " + method.getName() + " does not conform to (ProfilingData, " + this.targetClass.getName() + ", Object[])");
            }
            case AFTER_INVOCATION: {
                if (pt.length == 2 && pt[0] == ProfilingData.class && pt[1] == Object.class) break;
                throw new RuntimeException("Signature of method " + method.getName() + " does not conform to (ProfilingData, Object)");
            }
            case ON_EXCEPTION: {
                if (pt.length == 2 && pt[0] == ProfilingData.class && pt[1] == Exception.class) break;
                throw new RuntimeException("Signature of method " + method.getName() + " does not conform to (ProfilingData, Exception)");
            }
            default: {
                throw new AssertionError((Object)"Unknown ProfileMethodType");
            }
        }
    }

    private void findProfilingMethods() {
        Method[] methods;
        Class<?> clazz = this.getClass();
        for (Method method : methods = clazz.getMethods()) {
            this.processMethod(method);
        }
    }

    private void installDefaultMethod(Method method, ProfileMethodType type) {
        List<Method> list = this.defaultProfileMethods.get((Object)type);
        if (list == null) {
            list = new ArrayList<Method>();
            this.defaultProfileMethods.put(type, list);
        }
        list.add(method);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Installed '%s' as default %s method", new Object[]{method.getName(), type}));
        }
    }

    private void installProfileMethod(Method method, String name, ProfileMethodType type) {
        if (name.equals("*")) {
            this.installDefaultMethod(method, type);
            return;
        }
        List<Method> list = this.profileMethods.get((Object)type).get(name);
        if (list == null) {
            list = new ArrayList<Method>();
            this.profileMethods.get((Object)type).put(name, list);
        }
        list.add(method);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Installed '%s' for '%s'/%s", new Object[]{method.getName(), name, type}));
        }
    }

    private void invokeDefaultMethods(ProfileMethodType type, Object ... args) {
        this.invokeMethods(this.defaultProfileMethods.get((Object)type), args);
    }

    private void invokeMethods(List<Method> methods, Object ... args) {
        if (methods == null) {
            return;
        }
        for (Method m : methods) {
            try {
                m.invoke((Object)this, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void invokeSpecificMethods(ProfileMethodType type, String methodName, Object ... args) {
        this.invokeMethods(this.profileMethods.get((Object)type).get(methodName), args);
    }

    private void postProcessInvocation(ProfilingData data) {
        depth.set(depth.get() - 1);
        this.dataManager.add(data);
        if (data.isRoot()) {
            this.idGenerator.remove();
        }
    }

    private void processMethod(Method method) {
        ProfileMethod profileMethod = method.getAnnotation(ProfileMethod.class);
        if (profileMethod == null) {
            return;
        }
        String name = profileMethod.name();
        ProfileMethodType type = profileMethod.type();
        this.checkProfileMethodSignature(method, name, type);
        this.installProfileMethod(method, name, type);
    }
}

