/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.profiler;

import java.lang.reflect.Field;
import org.apache.cocoon.profiling.ProfileMethod;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.profiler.Profiler;
import org.apache.cocoon.sitemap.node.PipelineNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineNodeProfiler
extends Profiler<PipelineNode> {
    public PipelineNodeProfiler() {
        super(PipelineNode.class);
    }

    @ProfileMethod(name="invoke")
    public void beforeInvoke(ProfilingData data, PipelineNode component, Object[] args) {
        try {
            Field field = PipelineNode.class.getDeclaredField("type");
            field.setAccessible(true);
            String value = (String)field.get(component);
            if (value != null) {
                data.addData("type", value);
                String simpleName = component.getClass().getSimpleName();
                data.setDisplayName(String.format("%s (%s=%s)", simpleName, "type", value));
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading type from PipelineNode", e);
        }
    }
}

