/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.profiler;

import java.lang.reflect.Field;
import org.apache.cocoon.profiling.ProfileMethod;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.profiler.Profiler;
import org.apache.cocoon.sitemap.node.MatchNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchNodeProfiler
extends Profiler<MatchNode> {
    private final String[] fields = new String[]{"pattern", "regexp", "equals", "contains", "wildcard", "startsWith", "endsWith"};

    public MatchNodeProfiler() {
        super(MatchNode.class);
    }

    @ProfileMethod(name="invoke")
    public void beforeInvoke(ProfilingData data, MatchNode component, Object[] args) {
        try {
            for (String fieldname : this.fields) {
                Field field = MatchNode.class.getDeclaredField(fieldname);
                field.setAccessible(true);
                String value = (String)field.get(component);
                if (value == null) continue;
                data.addData(fieldname, value);
                String simpleName = component.getClass().getSimpleName();
                data.setDisplayName(String.format("%s (%s=%s)", simpleName, fieldname, value));
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading pattern from MatchNode", e);
        }
    }
}

