/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.data.ProfilingDataComparator;
import org.apache.cocoon.profiling.data.ProfilingDataHolder;
import org.apache.cocoon.profiling.data.ProfilingDataManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingDataManagerImpl
implements ProfilingDataManager {
    private HashMap<String, LinkedList<ProfilingData>> dataMap = new HashMap();
    private ProfilingDataHolder profilingDataHolder;

    @Override
    public void add(ProfilingData data) {
        String id = data.getProfilingId();
        LinkedList<ProfilingData> temp = this.dataMap.get(id);
        if (temp != null) {
            temp.add(data);
            if (data.isRoot()) {
                this.finish(id);
            }
        } else {
            temp = new LinkedList();
            this.dataMap.put(id, temp);
            temp.add(data);
        }
    }

    private ProfilingData buildTree(List<ProfilingData> list) {
        ProfilingData root = list.remove(0);
        int maxLevel = 0;
        while (!list.isEmpty()) {
            maxLevel = Math.max(maxLevel, list.get(0).getInvocationDepth());
            this.addNode(root, list);
        }
        for (int i = maxLevel; i > 1; --i) {
            this.correctChildAssignments(root, i);
        }
        return root;
    }

    private void correctChildAssignments(ProfilingData root, int level) {
        while (root.getInvocationDepth() < level - 2) {
            root = root.getChild(0);
        }
        ArrayList<ProfilingData> children = new ArrayList<ProfilingData>(root.getChild(0).getChildren());
        root.getChild(0).removeAllChildren();
        int size = root.getChildCount();
        ProfilingData temp = null;
        for (int i = 1; i < size; ++i) {
            while (!children.isEmpty() && root.getChild(i).getInvocationStartTime() > ((ProfilingData)children.get(0)).getInvocationStartTime()) {
                temp = (ProfilingData)children.remove(0);
                root.getChild(i - 1).addChild(temp);
            }
        }
        while (!children.isEmpty()) {
            temp = (ProfilingData)children.remove(0);
            root.getChild(size - 1).addChild(temp);
        }
    }

    private void addNode(ProfilingData root, List<ProfilingData> list) {
        ProfilingData data = list.remove(0);
        while (root.getInvocationDepth() < data.getInvocationDepth() && root.hasChildren()) {
            root = root.getChild(0);
        }
        if (root.getInvocationDepth() > data.getInvocationDepth()) {
            data.addChildren(root.getParent().getChildren());
            root.getParent().removeAllChildren();
            root.getParent().addChild(data);
            return;
        }
        if (root.getInvocationDepth() == data.getInvocationDepth()) {
            root.getParent().addChild(data);
            return;
        }
        if (!root.hasChildren()) {
            root.addChild(data);
            return;
        }
        throw new RuntimeException("Cannot add ProfilingData object to tree structure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(String id) {
        try {
            LinkedList<ProfilingData> list = this.dataMap.get(id);
            if (list.size() <= 3) {
                return;
            }
            Collections.sort(list, new ProfilingDataComparator());
            ProfilingData data = this.buildTree(list);
            this.profilingDataHolder.store(id, data);
        }
        finally {
            this.dataMap.remove(id);
        }
    }

    @Override
    public void setProfilingDataHolder(ProfilingDataHolder profilingDataHolder) {
        this.profilingDataHolder = profilingDataHolder;
    }
}

