/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.profiling.data.InstanceRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<InstanceRepresentation> arguments = new ArrayList<InstanceRepresentation>();
    private long callFrameIdentity;
    private List<ProfilingData> children = new ArrayList<ProfilingData>();
    private Map<String, String> data = new HashMap<String, String>();
    private String displayName;
    private Exception exception;
    private transient String id;
    private int invocationDepth;
    private Long invocationEndTime;
    private Long invocationStartTime;
    private String method;
    private ProfilingData parent;
    private String profiler;
    private String profilingId;
    private InstanceRepresentation returnValue;
    private boolean root;
    private InstanceRepresentation target;
    private long targetIdentity;

    public void addChild(ProfilingData data) {
        this.children.add(data);
        data.setParent(this);
    }

    public void addChildren(List<ProfilingData> children) {
        this.children.addAll(children);
        for (ProfilingData d : children) {
            d.setParent(this);
        }
    }

    public void addData(String key, String value) {
        this.data.put(key, value);
    }

    public List<InstanceRepresentation> getArguments() {
        return this.arguments;
    }

    public ProfilingData getChild(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public List<ProfilingData> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Map<String, String> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public String getData(String key) {
        return this.data.get(key);
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.target != null) {
            return this.target.getRepresentedClass().getSimpleName();
        }
        return this.toString();
    }

    public Exception getException() {
        return this.exception;
    }

    public double getExecutionMillis() {
        return (double)(this.invocationEndTime - this.invocationStartTime) / 1000000.0;
    }

    public String getId() {
        if (this.id == null) {
            this.id = String.valueOf(this.targetIdentity << (int)(32L + this.callFrameIdentity));
        }
        return this.id;
    }

    public int getInvocationDepth() {
        return this.invocationDepth;
    }

    public Long getInvocationEndTime() {
        return this.invocationEndTime;
    }

    public Long getInvocationStartTime() {
        return this.invocationStartTime;
    }

    public String getMethod() {
        return this.method;
    }

    public ProfilingData getParent() {
        return this.parent;
    }

    public String getProfiler() {
        return this.profiler;
    }

    public String getProfilingId() {
        return this.profilingId;
    }

    public InstanceRepresentation getReturnValue() {
        return this.returnValue;
    }

    public InstanceRepresentation getTarget() {
        return this.target;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isDisplayNameSet() {
        return this.displayName != null;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void removeAllChildren() {
        for (ProfilingData d : this.children) {
            d.setParent(null);
        }
        this.children.clear();
    }

    public boolean removeChild(ProfilingData data) {
        boolean success = this.children.remove(data);
        if (success) {
            data.setParent(null);
        }
        return success;
    }

    public void setArguments(Object[] arguments) {
        this.arguments.clear();
        for (Object o : arguments) {
            this.arguments.add(new InstanceRepresentation(o));
        }
    }

    public void setCallFrameId(int callFrameId) {
        this.id = null;
        this.callFrameIdentity = callFrameId;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setInvocationDepth(int depth) {
        this.invocationDepth = depth;
    }

    public void setInvocationEndTime(Long invocationEndTime) {
        this.invocationEndTime = invocationEndTime;
    }

    public void setInvocationStartTime(Long invocationStartTime) {
        this.invocationStartTime = invocationStartTime;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setProfiler(String profiler) {
        this.profiler = profiler;
    }

    public void setProfilingId(String profilingId) {
        this.profilingId = profilingId;
    }

    public void setReturnValue(Object obj) {
        this.returnValue = new InstanceRepresentation(obj);
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setTarget(Object target) {
        this.id = null;
        this.targetIdentity = System.identityHashCode(target);
        this.target = new InstanceRepresentation(target);
    }

    private void setParent(ProfilingData parent) {
        this.parent = parent;
    }
}

