/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.aspects;

import org.apache.cocoon.profiling.aspects.InvocationDispatcher;
import org.apache.cocoon.profiling.jmx.ProfilingManagement;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=0x7FFFFFFF)
public class ServletProfilingAspect {
    private InvocationDispatcher invocationDispatcher;
    private ProfilingManagement profilingManagement;

    @Around(value="execution(* service(..)) && target(javax.servlet.Servlet)")
    public Object handleInvocation(ProceedingJoinPoint pjp) throws Throwable {
        if (!this.profilingManagement.isEnabled()) {
            return pjp.proceed(pjp.getArgs());
        }
        if (pjp.getTarget().getClass().getName().startsWith("$Proxy")) {
            return pjp.proceed(pjp.getArgs());
        }
        return this.invocationDispatcher.dispatch(pjp);
    }

    public void setInvocationDispatcher(InvocationDispatcher invocationDispatcher) {
        this.invocationDispatcher = invocationDispatcher;
    }

    public void setProfilingManagement(ProfilingManagement profilingManagement) {
        this.profilingManagement = profilingManagement;
    }
}

