/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.aspects;

import org.apache.cocoon.profiling.aspects.InvocationDispatcher;
import org.apache.cocoon.profiling.jmx.ProfilingManagement;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class PipelineComponentProfilingAspect {
    private InvocationDispatcher invocationDispatcher;
    private ProfilingManagement profilingManagement;

    @Around(value="execution(* *(..)) && target(org.apache.cocoon.pipeline.component.PipelineComponent)")
    public Object handleInvocation(ProceedingJoinPoint pjp) throws Throwable {
        if (!this.profilingManagement.isEnabled()) {
            return pjp.proceed(pjp.getArgs());
        }
        return this.invocationDispatcher.dispatch(pjp);
    }

    public void setInvocationDispatcher(InvocationDispatcher invocationDispatcher) {
        this.invocationDispatcher = invocationDispatcher;
    }

    public void setProfilingManagement(ProfilingManagement profilingManagement) {
        this.profilingManagement = profilingManagement;
    }
}

