/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.profiling.aspects;

import java.util.LinkedList;
import java.util.List;
import org.apache.cocoon.profiling.data.ProfilingData;
import org.apache.cocoon.profiling.profiler.Profiler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationDispatcher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<Profiler<?>> profilers = new LinkedList();

    public Object dispatch(ProceedingJoinPoint pjp) throws Throwable {
        Object target = pjp.getTarget();
        ProfilingData data = new ProfilingData();
        Profiler<?> profiler = this.getProfiler(target);
        String method = pjp.getSignature().getName();
        try {
            profiler.before(data, target, method, pjp.getArgs());
            Object returnValue = pjp.proceed(pjp.getArgs());
            profiler.after(data, method, returnValue);
            return returnValue;
        }
        catch (Exception e) {
            profiler.exception(data, method, e);
            throw e;
        }
    }

    public void installProfiler(Profiler<?> profiler) {
        Class<?> class1 = profiler.getTargetClass();
        for (int i = 0; i < this.profilers.size(); ++i) {
            Class<?> class2 = this.profilers.get(i).getTargetClass();
            if (!class2.isAssignableFrom(class1)) continue;
            if (class1.equals(class2)) {
                throw new RuntimeException(String.format("You are trying to install a profiler for '%s' but for this class there is already a profiler registered: '%s'", class1.getName(), this.profilers.get(i).getClass().getName()));
            }
            this.profilers.add(i, profiler);
            return;
        }
        this.profilers.add(profiler);
    }

    private Profiler<?> getProfiler(Object target) {
        for (Profiler<?> profiler : this.profilers) {
            if (!profiler.getTargetClass().isInstance(target)) continue;
            return profiler;
        }
        throw new RuntimeException("No profiler found for " + target.getClass() + ".");
    }
}

